/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world.object;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.world.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Area {
    private Location center;
    private int radius;
    private int cooldown = -1;
    private Material material = null;
    private Material hollow = null;
    private boolean isUnbreakable;
    private List<UUID> playerZone = new ArrayList<UUID>();
    private List<Block> blocks = new ArrayList<Block>();

    public Area(Location center, int radius, int cooldown, Material material, Material hollow, boolean isUnbreakable) {
        this.center = center.clone();
        this.radius = radius;
        this.cooldown = cooldown;
        this.material = material;
        this.hollow = hollow;
        this.isUnbreakable = isUnbreakable;
        this.fillArea();
        if (cooldown != -1) {
            this.startTask();
        }
    }

    public Area(Location location, int radius, int cooldown, Material material) {
        this(location, radius, cooldown, material, null, false);
    }

    public Area(Location location, int radius) {
        this(location, radius, -1, null, null, false);
    }

    public Location getCenterLocation() {
        return this.center;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Material getHollow() {
        return this.hollow;
    }

    public List<UUID> getPlayerZone() {
        return this.playerZone;
    }

    public boolean isInArea(Player player) {
        if (player.getWorld() != this.center.getWorld()) {
            return false;
        }
        return this.center.distance(player.getLocation()) <= (double)this.radius;
    }

    public void fillArea() {
        if (this.material != null) {
            boolean applyPhysics = this.material != Material.STATIONARY_WATER || this.hollow != null;
            for (Location loc : MathUtil.getSphere(this.center, this.radius, false)) {
                Block block = loc.getBlock();
                if (block.getType() == Material.BEDROCK || Metadata.NO_BREAKING.has(block)) continue;
                block.setType(this.material, applyPhysics);
                if (!applyPhysics) {
                    Metadata.NO_PHYSICS.add(block);
                }
                if (this.isUnbreakable) {
                    Metadata.NO_BREAKING.add(block);
                }
                this.blocks.add(block);
            }
        }
        if (this.hollow != null) {
            for (Location loc : MathUtil.getSphere(this.center, this.radius + 1, true)) {
                Block block = loc.getBlock();
                if (block.getType() == Material.BEDROCK || Metadata.NO_BREAKING.has(block)) continue;
                block.setType(this.hollow);
                if (this.isUnbreakable) {
                    Metadata.NO_BREAKING.add(block);
                }
                this.blocks.add(block);
            }
        }
    }

    public void clearArea() {
        if (this.material == null) {
            for (Location loc : MathUtil.getSphere(this.center, this.radius, false)) {
                Block block2 = loc.getBlock();
                if (block2.getType() == Material.BEDROCK || Metadata.NO_BREAKING.has(block2)) continue;
                block2.setType(Material.AIR);
            }
        }
        this.blocks.forEach(block -> {
            Metadata.NO_PHYSICS.remove((Block)block);
            Metadata.NO_BREAKING.remove((Block)block);
            block.setType(Material.AIR);
        });
        this.blocks.clear();
    }

    public void startTask() {
        this.playerZone.clear();
        for (Player player : UHCPlayerManager.getPlayingsPlayer()) {
            this.onStart(player);
        }
        new BukkitRunnable(){
            private int time;
            {
                this.time = Area.this.cooldown;
            }

            public void run() {
                if (this.time <= 0) {
                    this.cancel();
                    for (Player player : UHCPlayerManager.getPlayingsPlayer()) {
                        Area.this.onFinish(player);
                    }
                    Area.this.clearArea();
                    return;
                }
                --this.time;
                Area.this.onSec();
                for (Player player : UHCPlayerManager.getPlayingsPlayer()) {
                    UUID uuid = player.getUniqueId();
                    boolean beforeZone = Area.this.playerZone.contains(uuid);
                    boolean isInArea = Area.this.isInArea(player);
                    if (!beforeZone && !isInArea) continue;
                    if (!beforeZone && isInArea) {
                        Area.this.onEnterArea(player);
                        Area.this.playerZone.add(uuid);
                        continue;
                    }
                    if (beforeZone && !isInArea) {
                        Area.this.onLeaveArea(player);
                        Area.this.playerZone.remove(uuid);
                        continue;
                    }
                    Area.this.onArea(player);
                }
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
    }

    public abstract void onEnterArea(Player var1);

    public abstract void onArea(Player var1);

    public abstract void onLeaveArea(Player var1);

    public void onSec() {
    }

    public void onStart(Player player) {
    }

    public void onFinish(Player player) {
    }
}

