/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world.monde;

import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.world.GameEnvironment;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.util.server.enums.ServerProperty;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class LobbyUtil {
    private static GameWorld lobby = null;
    private static boolean doLobbyReset = false;

    public static void initLobby() {
        lobby = new GameWorld(LobbyUtil.getLobbyName(), "Lobby", GameEnvironment.VOID);
        lobby.setBorderGame(false);
        lobby.setWorld((World)Bukkit.getWorlds().get(0));
        if (!doLobbyReset) {
            return;
        }
        LobbyUtil.setupLobby();
    }

    public static void setupLobby() {
        World world = (World)Bukkit.getWorlds().get(0);
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                world.getBlockAt(x, 99, z).setType(Material.BARRIER);
            }
        }
        for (int i = -11; i <= 11; ++i) {
            for (int h = 0; h <= 3; ++h) {
                world.getBlockAt(11, 99 + h, i).setType(Material.BARRIER);
                world.getBlockAt(-11, 99 + h, i).setType(Material.BARRIER);
                world.getBlockAt(i, 99 + h, 11).setType(Material.BARRIER);
                world.getBlockAt(i, 99 + h, -11).setType(Material.BARRIER);
            }
            world.getBlockAt(11, 103, i).setType(Material.STAINED_GLASS_PANE);
            world.getBlockAt(-11, 103, i).setType(Material.STAINED_GLASS_PANE);
            world.getBlockAt(i, 103, 11).setType(Material.STAINED_GLASS_PANE);
            world.getBlockAt(i, 103, -11).setType(Material.STAINED_GLASS_PANE);
        }
        world.setSpawnFlags(false, false);
        world.setSpawnLocation(0, 102, 0);
        while (!world.getEntities().isEmpty()) {
            ((Entity)world.getEntities().remove(0)).remove();
        }
        ConfigFile.LOBBY_LOCATION.setValue(new Location(LobbyUtil.getLobbyWorld(), 0.0, 102.0, 0.0));
        ConfigFile.LOBBY_RESET.setValue(false);
    }

    public static void resetLobby(Plugin plugin) {
        if (!LobbyUtil.canResetLobby(plugin)) {
            return;
        }
        doLobbyReset = true;
        ServerProperty.LEVEL_TYPE.setServerProperty("FLAT");
        ServerProperty.LEVEL_SETTINGS.setServerProperty("3;minecraft:air;1;");
        WorldUtil.deleteFile(new File(Bukkit.getWorldContainer(), LobbyUtil.getLobbyName()));
    }

    public static boolean canResetLobby(Plugin plugin) {
        if (Files.notExists(Paths.get(plugin.getDataFolder() + File.separator + "config.yml", new String[0]), new LinkOption[0])) {
            return true;
        }
        try {
            return Files.lines(Paths.get(plugin.getDataFolder() + File.separator + "config.yml", new String[0])).allMatch(s -> !s.contains("resetmap")) || Files.lines(Paths.get(plugin.getDataFolder() + File.separator + "config.yml", new String[0])).anyMatch(s -> s.contains("resetmap: true"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getLobbyName() {
        return ServerProperty.LEVEL_NAME.getStringProperty("world");
    }

    public static GameWorld getLobbyGame() {
        return lobby;
    }

    public static World getLobbyWorld() {
        return lobby.getWorld();
    }

    public static Location getLobbyLocation() {
        return ConfigFile.LOBBY_LOCATION.getLocation();
    }
}

