/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world.border;

import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.tasks.timer.border.BorderPhase;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import eu.scorpionltd.uhc.util.world.border.BorderEntry;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;

public class BorderUtil {
    public static void createBorders() {
        int size = Values.BORDER_SIZE_INIT.getInteger();
        ArrayList<World> worlds = new ArrayList<World>();
        for (GameWorld gameWorld : GameWorldManager.getGameWorlds()) {
            if (gameWorld.getWorld() == null || !gameWorld.hasBorderGame()) continue;
            worlds.add(gameWorld.getWorld());
        }
        worlds.forEach(w -> BorderUtil.setupBorder(w, size));
        Bukkit.getWorlds().forEach(world -> WorldUtil.changePVP(world, false));
    }

    public static void setupBorder(World world, int size) {
        WorldBorder border = world.getWorldBorder();
        border.setCenter((double)Values.BORDER_CENTER_X.getInteger(), (double)Values.BORDER_CENTER_Z.getInteger());
        border.setSize((double)(size * 2));
        border.setDamageAmount(Values.BORDER_TYPE.getInteger() == 1 ? 0.0 : 0.2);
        border.setDamageBuffer(1.0);
        border.setWarningDistance(0);
        border.setWarningTime(10);
        world.setDifficulty(Difficulty.HARD);
        world.setTime(0L);
    }

    public static void setupBorderSystem() {
        if (Values.BORDER_REDUCTION.getInteger() == 1) {
            new BorderEntry(Values.BORDER_SIZE_END.getInteger(), Values.BORDER_VITESSE.getInteger()).addEntry();
            return;
        }
        int borderPhase = Values.BORDER_SIZE_INIT.getInteger();
        int endSize = Values.BORDER_SIZE_END.getInteger();
        while (borderPhase > endSize) {
            int calculNextPhase = borderPhase - Values.BORDER_PHASE_BLOCKS.getInteger();
            borderPhase = calculNextPhase < endSize ? endSize : calculNextPhase;
            new BorderEntry(borderPhase, 0).addEntry();
        }
    }

    public static void goToNextPhase() {
        if (Values.BORDER_REDUCTION.getInteger() == 1 || !BorderEntry.hasNextEntry()) {
            return;
        }
        new BorderPhase();
    }

    public static int isOutside(Player p) {
        double x = p.getLocation().getX();
        double z = p.getLocation().getZ();
        double size = p.getWorld().getWorldBorder().getSize() / 2.0;
        int centerX = Values.BORDER_CENTER_X.getInteger();
        int centerZ = Values.BORDER_CENTER_Z.getInteger();
        if (x > 0.0 && x > size + (double)centerX) {
            return 1;
        }
        if (x < 0.0 && x < -size + (double)centerX) {
            return 2;
        }
        if (z > 0.0 && z > size + (double)centerZ) {
            return 3;
        }
        if (z < 0.0 && z < -size + (double)centerZ) {
            return 4;
        }
        return 0;
    }

    public static void teleportPlayerInBorder(Player p) {
        Location loc = p.getLocation();
        double valeur = 10.0;
        int border = BorderUtil.isOutside(p);
        Location upLoc = null;
        if (border == 1) {
            Location newLoc = new Location(loc.getWorld(), loc.getX() - valeur, loc.getY(), loc.getZ());
            upLoc = loc.getWorld().getHighestBlockAt(newLoc).getLocation();
        } else if (border == 2) {
            Location newLoc = new Location(loc.getWorld(), loc.getX() + valeur, loc.getY(), loc.getZ());
            upLoc = loc.getWorld().getHighestBlockAt(newLoc).getLocation();
        } else if (border == 3) {
            Location newLoc = new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ() - valeur);
            upLoc = loc.getWorld().getHighestBlockAt(newLoc).getLocation();
        } else if (border == 4) {
            Location newLoc = new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ() + valeur);
            upLoc = loc.getWorld().getHighestBlockAt(newLoc).getLocation();
        }
        p.teleport(new Location(loc.getWorld(), upLoc.getX() + 0.5, upLoc.getY() + 0.5, upLoc.getZ() + 0.5));
    }
}

