/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world.border;

import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;

public class BorderEntry {
    private static List<BorderEntry> queue = new ArrayList<BorderEntry>();
    public Integer sizeFinal;
    public Integer time;

    public static List<BorderEntry> getQueue() {
        return queue;
    }

    public static boolean hasNextEntry() {
        return !queue.isEmpty();
    }

    public static BorderEntry getNextEntry() {
        return queue.remove(0);
    }

    public BorderEntry(Integer sizeFinal, Integer time) {
        this.sizeFinal = sizeFinal;
        this.time = time;
    }

    public void addEntry() {
        queue.add(this);
    }

    public void start() {
        ArrayList<World> worlds = new ArrayList<World>();
        for (GameWorld gameWorld : GameWorldManager.getTeleportationWorlds()) {
            if (gameWorld.getWorld() == null) continue;
            worlds.add(gameWorld.getWorld());
            if (gameWorld.getNether() != null && Values.NETHER_ACCESS.getBoolean()) {
                worlds.add(gameWorld.getNether().getWorld());
            }
            if (gameWorld.getEnd() == null || !Values.END_ACCESS.getBoolean()) continue;
            worlds.add(gameWorld.getEnd().getWorld());
        }
        worlds.stream().map(w -> w.getWorldBorder()).forEach(border -> border.setSize((double)(this.sizeFinal * 2), (long)this.time.intValue()));
    }
}

