/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world;

import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.tasks.runnable.GameTimer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class WorldUtil {
    public static List<World> getWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        for (GameWorld gameWorld : GameWorldManager.getGameWorlds()) {
            if (gameWorld.getWorld() == null) continue;
            worlds.add(gameWorld.getWorld());
        }
        return worlds;
    }

    public static boolean existsWorldFile(String worldName) {
        File file = new File(Bukkit.getServer().getWorldContainer(), worldName);
        return file.exists();
    }

    public static World loadWorldFile(String worldName) {
        if (!WorldUtil.existsWorldFile(worldName)) {
            return null;
        }
        WorldCreator wc = new WorldCreator(worldName);
        if (worldName.contains("nether")) {
            wc.environment(World.Environment.NETHER);
        }
        if (worldName.contains("end")) {
            wc.environment(World.Environment.THE_END);
        }
        World world = wc.createWorld();
        world.setAutoSave(false);
        world.setSpawnLocation(0, 150, 0);
        return world;
    }

    public static World loadWorldFile(String worldName, World.Environment environment) {
        if (!WorldUtil.existsWorldFile(worldName)) {
            return null;
        }
        WorldCreator wc = new WorldCreator(worldName);
        wc.environment(environment);
        World world = wc.createWorld();
        world.setAutoSave(false);
        world.setSpawnLocation(0, 150, 0);
        return world;
    }

    public static boolean deleteFile(File path) {
        try {
            FileUtils.deleteDirectory((File)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean containsWorld(String name) {
        return Bukkit.getWorld((String)name) != null;
    }

    public static ValueCategorie getValueCategorie(World world) {
        World.Environment env = WorldUtil.getEnv(world);
        return env == World.Environment.NORMAL ? ValueCategorie.OVERWORLD : (env == World.Environment.NETHER ? ValueCategorie.NETHER : ValueCategorie.END);
    }

    public static World.Environment getEnv(World world) {
        return world.getEnvironment();
    }

    public static World.Environment getEnv(Location loc) {
        return WorldUtil.getEnv(loc.getWorld());
    }

    public static World.Environment getEnv(Player p) {
        return WorldUtil.getEnv(p.getWorld());
    }

    public static boolean isDay() {
        int timeDay;
        int dureeCycle = Values.TIMERS_DUREE_CYCLE.getInteger();
        int repartitionCycle = Values.TIMERS_REPARTITION_CYCLE.getInteger();
        int timeInThisEpisode = GameTimer.getTime() % dureeCycle;
        return timeInThisEpisode < (timeDay = dureeCycle * repartitionCycle / 100);
    }

    public static boolean isNight() {
        int timeDay;
        int dureeCycle = Values.TIMERS_DUREE_CYCLE.getInteger();
        int repartitionCycle = Values.TIMERS_REPARTITION_CYCLE.getInteger();
        int timeInThisEpisode = GameTimer.getTime() % dureeCycle;
        return timeInThisEpisode >= (timeDay = dureeCycle * repartitionCycle / 100);
    }

    public static int getWorldsNumber() {
        return Bukkit.getWorlds().size();
    }

    public static int getWorldsLigne() {
        return (int)Math.ceil(WorldUtil.getWorldsNumber() / 9) + 1;
    }

    public static void changePVP(World world, boolean value) {
        world.setPVP(value);
    }

    public static List<Block> getNearbyBlocks(Location location, int radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = location.getBlockX() - radius; x <= location.getBlockX() + radius; ++x) {
            for (int y = location.getBlockY() - radius; y <= location.getBlockY() + radius; ++y) {
                for (int z = location.getBlockZ() - radius; z <= location.getBlockZ() + radius; ++z) {
                    blocks.add(location.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static boolean isSurface(Location loc) {
        return loc.getY() > 0.0 && loc.getY() < (double)loc.getWorld().getMaxHeight() && loc.getBlock().getLightFromSky() > 0;
    }

    public static Location getCenter(Location loc) {
        return new Location(loc.getWorld(), 0.0, loc.getY(), 0.0);
    }

    public static boolean isInWater(Location loc) {
        return loc.getBlock() != null && loc.getBlock().getType() != null && (loc.getBlock().getType() == Material.STATIONARY_WATER || loc.getBlock().getType() == Material.WATER);
    }

    public static boolean isInLava(Location loc) {
        return loc.getBlock() != null && loc.getBlock().getType() != null && (loc.getBlock().getType() == Material.STATIONARY_LAVA || loc.getBlock().getType() == Material.LAVA);
    }
}

