/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.item.loot.Interval;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class TeleportationUtil {
    private static int worldNumber = 0;
    private static HashMap<UHCPlayer, Location> customLocations = new HashMap();

    public static void setWorldNumber(int value) {
        worldNumber = value;
    }

    public static void teleportAllToLobby() {
        for (final Player player : Bukkit.getOnlinePlayers()) {
            if (player.getWorld() == LobbyUtil.getLobbyWorld()) continue;
            new BukkitRunnable(){

                public void run() {
                    player.teleport(LobbyUtil.getLobbyLocation());
                }
            }.runTaskLater((Plugin)UHC.getInstance(), 5L);
        }
    }

    public static void teleportPlayer(UHCPlayer player, Location loc, TeleportRunnable runnable) {
        if (player.getPlayer() == null) {
            return;
        }
        player.getPlayer().teleport(loc);
        if (runnable != null) {
            runnable.run(player);
        }
    }

    public static void teleportListPlayer(List<UHCPlayer> list, Location center, int radius, TeleportRunnable runnable) {
        Set<Vector> spreadSpawns = MathUtil.getCircle(5.0, list.size(), false, -1.0);
        for (UHCPlayer p : list) {
            if (p.getPlayer() == null) continue;
            Vector v = (Vector)spreadSpawns.toArray()[list.indexOf(p)];
            Location loc = new Location(center.getWorld(), (double)center.getBlockX() + v.getX(), (double)center.getBlockY() + v.getY(), (double)center.getBlockZ() + v.getZ());
            TeleportationUtil.teleportPlayer(p, loc, runnable);
        }
    }

    public static void findLocations(World world, List<Location> locations, int numberLocations) {
        if (numberLocations < 1) {
            numberLocations = 1;
        }
        for (int i = 0; i < numberLocations; ++i) {
            locations.add(TeleportationUtil.createSpawnLocation(world, locations));
        }
    }

    public static void generateSpawnPoints(List<World> worlds, Iterator<UHCPlayer> players, HashMap<UHCPlayer, Location> map, int number) {
        int i = 0;
        boolean isTeleportableTeam = UHC.getTeamManager().isTeleportableTeam();
        while (players.hasNext() && i < number) {
            Location location;
            UHCPlayer player = players.next();
            if (map.containsKey(player)) {
                players.remove();
                continue;
            }
            World world = worlds.get(worldNumber);
            if (++worldNumber >= worlds.size()) {
                worldNumber = 0;
            }
            Location location2 = location = TeleportationUtil.haveCustomLocations() && TeleportationUtil.getCustomLocations().containsKey(player) ? TeleportationUtil.getCustomLocations().get(player) : TeleportationUtil.createSpawnLocation(world, new ArrayList<Location>(map.values()));
            if (UHC.getTeam(player) != null && isTeleportableTeam) {
                UHCTeam team = UHC.getTeam(player);
                List<Location> teamLocations = TeleportationUtil.createAroundSpawnLocation(world, location, team.getAlivePlayers().size() - 1);
                for (UHCPlayer teamPlayer : team.getAlivePlayers()) {
                    if (teamPlayer == player || teamLocations.isEmpty()) continue;
                    map.put(teamPlayer, teamLocations.remove(0));
                    ++i;
                }
            }
            map.put(player, location);
            players.remove();
            ++i;
        }
    }

    public static Location createSpawnLocation(World world, List<Location> locations) {
        Location spawnLocation = null;
        for (int attempt = 0; attempt <= 50 && (spawnLocation == null || TeleportationUtil.isTooClose(locations, spawnLocation)); ++attempt) {
            spawnLocation = TeleportationUtil.getRandomLocation(world);
        }
        if (spawnLocation == null) {
            return world.getHighestBlockAt(0, 0).getLocation();
        }
        return spawnLocation;
    }

    public static Location createGameSpawnLocation(World world) {
        return TeleportationUtil.createSpawnLocation(world, new ArrayList<Location>());
    }

    public static Location createGameSpawnLocation() {
        return TeleportationUtil.createGameSpawnLocation(GameWorldManager.getTeleportationBukkitWorlds().get(new Random().nextInt(GameWorldManager.getTeleportationBukkitWorlds().size())));
    }

    public static List<Location> createAroundSpawnLocation(World world, Location center, int numbers) {
        ArrayList<Location> spawnLocations = new ArrayList<Location>();
        Set<Vector> spreadSpawns = MathUtil.getCircle(5.0, numbers, false, -1.0);
        for (Vector v : spreadSpawns) {
            spawnLocations.add(new Location(center.getWorld(), (double)center.getBlockX() + v.getX(), (double)center.getBlockY() + v.getY(), (double)center.getBlockZ() + v.getZ()));
        }
        if (spawnLocations.isEmpty()) {
            System.out.println("(SupUHC) TeleportationUtil.createAroundSpawnLocation(" + world.getName() + ", " + center.toString() + ", " + numbers + ") : spawnLocations is empty !");
        }
        return spawnLocations;
    }

    public static boolean isTooClose(List<Location> list, Location loc) {
        int size = (int)(loc.getWorld().getWorldBorder().getSize() / 2.0);
        if (size - Math.abs(loc.getBlockX()) < 20 || Math.abs(size - loc.getBlockZ()) < 20) {
            return true;
        }
        return list.stream().anyMatch(l -> l.getWorld() == loc.getWorld() && l.distance(loc) < 40.0);
    }

    public static Location getRandomLocation(World w) {
        List<Material> mat = Arrays.asList(Material.LAVA, Material.AIR, Material.STATIONARY_LAVA, Material.FIRE);
        int size = (int)((w.getWorldBorder().getSize() - w.getWorldBorder().getSize() * 0.1) / 2.0);
        int centerX = Values.BORDER_CENTER_X.getInteger();
        int centerZ = Values.BORDER_CENTER_Z.getInteger();
        int x = new Interval((Object)(-size + centerX), (Object)(size + centerX)).getAsRandomInt();
        int z = new Interval((Object)(-size + centerZ), (Object)(size + centerZ)).getAsRandomInt();
        Location loc = new Location(w, (double)x, 0.0, (double)z);
        if ((loc = loc.getWorld().getHighestBlockAt(loc).getLocation()) != null && !mat.contains(loc.getBlock().getRelative(BlockFace.DOWN).getType())) {
            return loc.add(0.0, 40.0, 0.0);
        }
        return null;
    }

    public static boolean haveCustomLocations() {
        return !customLocations.isEmpty();
    }

    public static void addCustomLocations(UHCPlayer player, Location loc) {
        customLocations.put(player, loc);
    }

    public static HashMap<UHCPlayer, Location> getCustomLocations() {
        return customLocations;
    }

    public static interface TeleportRunnable {
        public void run(UHCPlayer var1);
    }
}

