/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.v1_8_R3.EnumParticle;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutWorldParticles;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class MathUtil {
    public static Set<Vector> circle = new HashSet<Vector>(MathUtil.getSphereAbove(3.0, 5, true, 1.0));

    public static void sendCircleParticle(EnumParticle particle, Location center, double radius, int amount) {
        double increment = Math.PI * 2 / (double)amount;
        for (int i = 0; i < amount; ++i) {
            double angle = (double)i * increment;
            double x = center.getX() + radius * Math.cos(angle);
            double z = center.getZ() + radius * Math.sin(angle);
            PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, true, (float)x, (float)center.getY() + 0.5f, (float)z, 0.0f, 0.0f, 0.0f, 0.0f, 10, null);
            for (Player p : Bukkit.getOnlinePlayers()) {
                ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet);
            }
        }
    }

    public static Set<Vector> getCircle(Double radius, Integer amount, Boolean full, Double space) {
        Double z;
        Double x;
        HashSet<Vector> list = new HashSet<Vector>();
        Double increment = Math.PI * 2 / (double)amount.intValue();
        Double angle = 0.0;
        while (angle <= Math.PI * 2) {
            x = radius * Math.cos(angle);
            z = radius * Math.sin(angle);
            list.add(new Vector(x.intValue(), 0, z.intValue()));
            angle = angle + increment;
        }
        if (full.booleanValue()) {
            while (radius > 0.0) {
                radius = radius - space;
                angle = 0.0;
                while (angle <= Math.PI * 2) {
                    x = radius * Math.cos(angle);
                    z = radius * Math.sin(angle);
                    list.add(new Vector(x.intValue(), 0, z.intValue()));
                    angle = angle + increment;
                }
            }
        }
        return list;
    }

    private static Set<Vector> getSphereAbove(Double radius, Integer amount, Boolean full, Double space) {
        HashSet<Vector> list = new HashSet<Vector>();
        Integer y = 0;
        Double r = radius;
        while (r > 0.0) {
            for (Vector v : MathUtil.getCircle(r, amount, full, space)) {
                v.setY(v.getY() + (double)y.intValue());
                list.add(v);
            }
            r = r - 1.0;
            Integer n = y;
            Integer n2 = y = Integer.valueOf(y + 1);
        }
        return list;
    }

    public static List<Location> getSphere(Location centerBlock, int radius, boolean hollow) {
        ArrayList<Location> circleBlocks = new ArrayList<Location>();
        int bX = centerBlock.getBlockX();
        int bY = centerBlock.getBlockY();
        int bZ = centerBlock.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - radius; y <= bY + radius; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    double distance = (bX - x) * (bX - x) + (bZ - z) * (bZ - z) + (bY - y) * (bY - y);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1))) continue;
                    circleBlocks.add(new Location(centerBlock.getWorld(), (double)x, (double)y, (double)z));
                }
            }
        }
        return circleBlocks;
    }

    public static List<Location> getCircle(Location centerBlock, int radius, boolean hollow) {
        ArrayList<Location> circleBlocks = new ArrayList<Location>();
        int bX = centerBlock.getBlockX();
        int bY = centerBlock.getBlockY();
        int bZ = centerBlock.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int z = bZ - radius; z <= bZ + radius; ++z) {
                double distance = (bX - x) * (bX - x) + (bZ - z) * (bZ - z);
                if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1))) continue;
                circleBlocks.add(new Location(centerBlock.getWorld(), (double)x, (double)bY, (double)z));
            }
        }
        return circleBlocks;
    }

    public static String convertDouble(double damage) {
        DecimalFormat nf = new DecimalFormat("##.##");
        return nf.format(damage);
    }

    public static double convertPercent(double health) {
        double hearts = health / 2.0;
        double percent = hearts * 10.0;
        return percent;
    }

    public static boolean isInt(String s) {
        try {
            int i = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException er) {
            return false;
        }
    }

    public static boolean isDouble(String s) {
        try {
            double i = Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException er) {
            return false;
        }
    }

    public static boolean isBoolean(String s) {
        try {
            boolean i = Boolean.parseBoolean(s);
            return true;
        }
        catch (NumberFormatException er) {
            return false;
        }
    }

    public static Vector getDirectionBetweenLocations(Location loc1, Location loc2) {
        Vector from = loc1.toVector();
        Vector to = loc2.toVector();
        return to.subtract(from);
    }

    public static boolean getLookingAt(Player player, Player target) {
        Location eye = player.getEyeLocation();
        Vector toEntity = target.getEyeLocation().toVector().subtract(eye.toVector());
        double dot = toEntity.normalize().dot(eye.getDirection());
        return dot > 0.99;
    }

    public static boolean getLookingBody(Player player, Player target, int radius) {
        List blocs = player.getLineOfSight((Set)null, radius);
        if (blocs == null || blocs.isEmpty()) {
            return false;
        }
        return blocs.contains(target.getLocation().getBlock()) || blocs.contains(target.getLocation().getBlock().getRelative(BlockFace.UP));
    }
}

