/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.world;

import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.utils.item.loot.Loot;
import eu.scorpionltd.utils.item.loot.LootItem;
import eu.scorpionltd.utils.item.loot.VarsLoot;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class BlockUtil {
    public static void breakBlock(Block block) {
        BlockUtil.breakBlock(block, null);
    }

    public static void breakBlock(Block block, Player player) {
        boolean isLootable;
        if (player != null && UHCPlayerManager.getPlayer(player).isPlaying()) {
            UHCPlayer up = UHCPlayerManager.getPlayer(player.getUniqueId());
            if (block.getType() == Material.DIAMOND_ORE && !Metadata.FAKE_DIAMONDS.has(block)) {
                up.getInfos().addCurrentDiamonds();
            }
            if (block.getType() == Material.GOLD_ORE) {
                up.getInfos().addCurrentGolds();
            }
            if (block.getType() == Material.IRON_ORE) {
                up.getInfos().addCurrentIrons();
            }
        }
        BlockBreakEvent breakEvent = null;
        if (player != null) {
            breakEvent = new BlockBreakEvent(block, player);
            if (block.getType() == Material.DIAMOND_ORE && !Metadata.FAKE_DIAMONDS.has(block) || block.getType() == Material.REDSTONE_ORE || block.getType() == Material.EMERALD_ORE || block.getType() == Material.GLOWING_REDSTONE_ORE || block.getType() == Material.COAL || block.getType() == Material.LAPIS_ORE) {
                breakEvent.setExpToDrop(1);
            }
        }
        if (!(isLootable = BlockUtil.checkBlock(block, breakEvent))) {
            block.breakNaturally();
            return;
        }
        block.setType(Material.AIR);
    }

    public static boolean checkBlock(Block b, BlockBreakEvent event) {
        Material mat = b.getType();
        HashMap loots = VarsLoot.getBlocksLoots();
        if (!loots.containsKey(mat)) {
            return false;
        }
        Loot loot = (Loot)loots.get(mat);
        World w = b.getLocation().getWorld();
        int multiplicateur = 1;
        if (event != null) {
            ItemStack hand = event.getPlayer().getItemInHand();
            boolean hasSilkTouchEffect = hand != null && hand.getType() != null && hand.getType() != Material.SHEARS && hand.containsEnchantment(Enchantment.SILK_TOUCH);
            boolean bl = hasSilkTouchEffect;
            if (!InventoryUtil.haveGoodItem(hand, b) || hasSilkTouchEffect) {
                return false;
            }
            if (loot.getExp() != 0.0) {
                ExperienceOrb orb = (ExperienceOrb)w.spawn(b.getLocation(), ExperienceOrb.class);
                orb.setExperience((int)(event.getExpToDrop() == 0 ? loot.getExp() : loot.getExp() * (double)event.getExpToDrop()));
            }
            if (hand.containsEnchantment(Enchantment.LOOT_BONUS_BLOCKS)) {
                multiplicateur = (int)((double)multiplicateur + 0.5 * (double)hand.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS));
            }
        }
        for (LootItem item : loot.getLoots()) {
            ItemStack lootItem = item.getLootItem();
            if (lootItem == null || lootItem.getType() == Material.AIR || lootItem.getAmount() <= 0) continue;
            double calcul = (double)lootItem.getAmount() * (new Random().nextBoolean() ? Math.ceil(multiplicateur) : Math.floor(multiplicateur));
            lootItem.setAmount((int)calcul);
            if (mat == Material.LOG || mat == Material.LOG_2) {
                Integer amount = lootItem.getAmount();
                byte data = (byte)(b.getData() & 3);
                lootItem = new ItemStack(mat, amount.intValue(), (short)data);
            }
            InventoryUtil.dropItem(b.getLocation(), lootItem);
        }
        return true;
    }

    public static List<Material> getRandomMaterials() {
        return Arrays.asList(Material.DIAMOND, Material.IRON_INGOT, Material.GOLD_INGOT, Material.EMERALD, Material.NETHER_BRICK, Material.FLINT, Material.QUARTZ, Material.BLAZE_ROD, Material.GLOWSTONE, Material.FURNACE, Material.WOOL, Material.COAL, Material.BLAZE_POWDER, Material.GOLD_BLOCK, Material.DIAMOND_BLOCK, Material.IRON_BLOCK, Material.TNT, Material.MOSSY_COBBLESTONE, Material.ENDER_PORTAL_FRAME, Material.DISPENSER, Material.HAY_BLOCK, Material.JUKEBOX, Material.PUMPKIN, Material.ENCHANTMENT_TABLE, Material.PACKED_ICE, Material.MELON_BLOCK, Material.BEACON, Material.RED_SANDSTONE, Material.ANVIL, Material.ITEM_FRAME, Material.SAPLING, Material.PISTON_STICKY_BASE, Material.REDSTONE_BLOCK, Material.DARK_OAK_DOOR_ITEM, Material.MINECART, Material.PAPER, Material.SLIME_BALL, Material.SADDLE, Material.DAYLIGHT_DETECTOR, Material.SPONGE, Material.COBBLE_WALL, Material.GRASS, Material.RED_ROSE, Material.GLOWSTONE, Material.CLAY, Material.WOOD, Material.CACTUS, Material.ENDER_CHEST, Material.EMERALD_BLOCK, Material.WHEAT, Material.FLOWER_POT_ITEM, Material.PRISMARINE_SHARD, Material.SUGAR_CANE, Material.RABBIT_HIDE);
    }

    public static boolean isLiquid(Material type) {
        return type == Material.WATER || type == Material.STATIONARY_WATER || type == Material.LAVA || type == Material.STATIONARY_LAVA;
    }

    public static Block getBlockLookingAt(Player player, int distance) {
        Block block = player.getTargetBlock((Set)null, distance);
        if (block == null || block.getType() == null || block.getType() == Material.AIR) {
            return null;
        }
        return block;
    }

    public static BlockFace getFaceLookingAt(Player player, int distance) {
        List blocks = player.getLastTwoTargetBlocks((Set)null, distance);
        if (blocks.size() != 2 || blocks.get(1) == null || ((Block)blocks.get(1)).getType() == null || !((Block)blocks.get(1)).getType().isOccluding() || blocks.get(0) == null) {
            return null;
        }
        Block targetBlock = (Block)blocks.get(1);
        Block adjacentBlock = (Block)blocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }
}

