/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.server.enums;

import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import org.fusesource.jansi.Ansi;

public enum Status {
    LAUNCH("status.launch", false, false),
    WAITING("status.waiting", false, false),
    COOLDOWN("status.cooldown", false, false),
    IN_GAME("status.ingame", true, false),
    FINISH("status.finish", true, true),
    RESTART("status.restart", true, true);

    private String key;
    private boolean isStart;
    private boolean isFinish;
    private static Status currentStatus;

    private Status(String key, boolean isStart, boolean isFinish) {
        this.key = key;
        this.isStart = isStart;
        this.isFinish = isFinish;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public UHCMessage getMessage() {
        return UHCMessage.get(this.key);
    }

    public static Status getCurrentStatus() {
        return currentStatus;
    }

    public static void setCurrentStatus(Status status) {
        currentStatus = status;
        String yellow = Ansi.ansi().fg(Ansi.Color.YELLOW).boldOff().toString();
        String white = Ansi.ansi().fg(Ansi.Color.WHITE).boldOff().toString();
        System.out.println(yellow + "-----------------" + white);
        System.out.println(yellow + "NEW STATUS: " + status.name() + white);
        System.out.println(yellow + "-----------------" + white);
        ServerUtil.sendStatutChangeEvent();
    }

    static {
        currentStatus = LAUNCH;
    }
}

