/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.server.enums;

import eu.scorpionltd.uhc.UHC;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public enum Metadata {
    BYPASS_SPAWNLIMIT("bypass_spawnlimit"),
    PLACED_BLOCKS("placed_blocks"),
    FAKE_DIAMONDS("fake_diamonds"),
    NO_BREAKING("no_breaking"),
    NO_PHYSICS("no_physics"),
    CHECKED_BLOCKS("checked_blocks"),
    HIDE_GOLD("hide_golds"),
    HIDE_DIAMOND("hide_diamond"),
    HIDE_EMERALD("hide_emerald"),
    INVISIBLE_ARMOR("invisible_armor"),
    DOUBLE_JUMP("double_jump"),
    CANT_PLACED_BLOCKS("cant_placed_blocks"),
    CANT_DROP("cant_drop"),
    NO_JUMP("no_jump"),
    NO_DAMAGE("no_damage"),
    NO_FALL("no_fall"),
    NO_EXPLOSION("no_explosion"),
    NO_FIRE("no_fire"),
    NO_POISON("no_poison"),
    NO_LIGHTNING("no_lightning"),
    FIRST_DAMAGE("first_damage"),
    FIRST_FALL("first_fall"),
    FIRST_EXPLOSION("first_explosion"),
    FIRST_FIRE("first_fire"),
    FIRST_POISON("first_poison"),
    FIRST_LIGHTNING("first_poison"),
    KILLED_BY_BAT("killed_by_bat"),
    CONFIRM_ACTION("confirm_action");

    private String key;

    private Metadata(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getTempKey() {
        return "temp_" + this.key;
    }

    public boolean has(Player player) {
        return player.hasMetadata(this.getTempKey()) || player.hasMetadata(this.key);
    }

    public void add(Player player) {
        player.setMetadata(this.key, (MetadataValue)new FixedMetadataValue((Plugin)UHC.getInstance(), (Object)this.key));
    }

    public void addCooldown(final Player player, final int time) {
        player.setMetadata(this.getTempKey(), (MetadataValue)new FixedMetadataValue((Plugin)UHC.getInstance(), (Object)this.getTempKey()));
        new BukkitRunnable(){
            private UUID uuid;
            private int cooldown;
            {
                this.uuid = player.getUniqueId();
                this.cooldown = time;
            }

            public void run() {
                if (this.cooldown <= 0) {
                    Player newPlayer = Bukkit.getPlayer((UUID)this.uuid);
                    if (newPlayer != null && newPlayer.isOnline()) {
                        this.cancel();
                        if (!newPlayer.hasMetadata(Metadata.this.getTempKey())) {
                            return;
                        }
                        newPlayer.removeMetadata(Metadata.this.getTempKey(), (Plugin)UHC.getInstance());
                    }
                    return;
                }
                --this.cooldown;
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
    }

    public void remove(Player player) {
        if (!player.hasMetadata(this.key)) {
            return;
        }
        player.removeMetadata(this.key, (Plugin)UHC.getInstance());
    }

    public void addAll() {
        Bukkit.getOnlinePlayers().forEach(player -> this.add((Player)player));
    }

    public void removeAll() {
        Bukkit.getOnlinePlayers().forEach(player -> this.remove((Player)player));
    }

    public boolean has(Block block) {
        return block.hasMetadata(this.key);
    }

    public void add(Block block) {
        block.setMetadata(this.key, (MetadataValue)new FixedMetadataValue((Plugin)UHC.getInstance(), (Object)this.key));
    }

    public void remove(Block block) {
        if (!this.has(block)) {
            return;
        }
        block.removeMetadata(this.key, (Plugin)UHC.getInstance());
    }

    public boolean has(Entity entity) {
        return entity.hasMetadata(this.key);
    }

    public void add(Entity entity) {
        entity.setMetadata(this.key, (MetadataValue)new FixedMetadataValue((Plugin)UHC.getInstance(), (Object)this.key));
    }

    public void remove(Entity entity) {
        if (!this.has(entity)) {
            return;
        }
        entity.removeMetadata(this.key, (Plugin)UHC.getInstance());
    }
}

