/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.server;

import eu.scorpionltd.uhc.events.custom.player.game.GameStartEvent;
import eu.scorpionltd.uhc.events.custom.player.game.GameWinEvent;
import eu.scorpionltd.uhc.events.custom.server.ScenarioChangeEvent;
import eu.scorpionltd.uhc.events.custom.server.SlotsChangeEvent;
import eu.scorpionltd.uhc.events.custom.server.StatutChangeEvent;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.utils.depends.Reflection;
import eu.scorpionltd.utils.task.Cooldown;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.OpList;
import net.minecraft.server.v1_8_R3.WhiteList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.IndexHelpTopic;
import org.bukkit.plugin.Plugin;

public class ServerUtil {
    public static void setupWhitelist() {
        WhiteList whitelist = MinecraftServer.getServer().getPlayerList().getWhitelist();
        whitelist.getValues().clear();
        if (ConfigFile.OP_CLEAR_IN_START.getBoolean()) {
            OpList opList = MinecraftServer.getServer().getPlayerList().getOPs();
            opList.getValues().clear();
        }
    }

    public static void setupBungeeCordChannel(Plugin plugin) {
        String bungeeCord = "BungeeCord";
        if (!ConfigFile.BUNGEE_ENABLE.getBoolean()) {
            if (Bukkit.getServer().getMessenger().isIncomingChannelRegistered(plugin, bungeeCord)) {
                Bukkit.getServer().getMessenger().unregisterIncomingPluginChannel(plugin, bungeeCord);
            }
            return;
        }
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel(plugin, bungeeCord);
    }

    public static void sendStartRequest() {
        Bukkit.getPluginManager().callEvent((Event)new GameStartEvent());
    }

    public static void sendWinRequest() {
        if (Status.getCurrentStatus().isFinish()) {
            return;
        }
        new Cooldown(1){

            public void onFinish() {
                Bukkit.getPluginManager().callEvent((Event)new GameWinEvent());
            }
        };
    }

    public static void sendStopRequest() {
        if (!ConfigFile.FINISH_AUTO_STOP.getBoolean()) {
            return;
        }
        new Cooldown(ConfigFile.FINISH_STOP_COOLDOWN.getInteger()){

            public void onFinish() {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "stopuhc");
            }
        };
    }

    public static void sendSlotsChangeEvent(Settings param) {
        if (param == Values.SERVER_SLOTS.getSettings()) {
            Bukkit.getPluginManager().callEvent((Event)new SlotsChangeEvent((Integer)param.getValue()));
        }
    }

    public static void sendStatutChangeEvent() {
        Bukkit.getPluginManager().callEvent((Event)new StatutChangeEvent());
    }

    public static void sendScenariosChangeEvent(Scenario scenario) {
        Bukkit.getPluginManager().callEvent((Event)new ScenarioChangeEvent(scenario));
    }

    public static boolean isGameFull() {
        return UHCPlayerManager.getPlayersNumber() >= Values.SERVER_SLOTS.getInteger();
    }

    public static boolean isPreWhitelistFull() {
        return (double)UHCPlayerManager.getPreWhitelistNumber() >= (double)Values.SERVER_SLOTS.getInteger() * ((double)ConfigFile.PRE_WHITELIST_PERCENT.getInteger() / 100.0);
    }

    public static String getTPS() {
        Class minecraftServerClass = Reflection.getNMSClass((String)"MinecraftServer");
        Method getServerMethod = Reflection.makeMethod((Class)minecraftServerClass, (String)"getServer", (Class[])new Class[0]);
        Object server = Reflection.callMethod((Method)getServerMethod, null, (Object[])new Object[0]);
        Field recentTpsField = Reflection.makeField((Class)minecraftServerClass, (String)"recentTps");
        double[] recent = (double[])Reflection.getField((Field)recentTpsField, (Object)server);
        return "" + Math.min((double)Math.round(recent[0] * 100.0) / 100.0, 20.0);
    }

    public static double getDoubleTPS() {
        Class minecraftServerClass = Reflection.getNMSClass((String)"MinecraftServer");
        Method getServerMethod = Reflection.makeMethod((Class)minecraftServerClass, (String)"getServer", (Class[])new Class[0]);
        Object server = Reflection.callMethod((Method)getServerMethod, null, (Object[])new Object[0]);
        Field recentTpsField = Reflection.makeField((Class)minecraftServerClass, (String)"recentTps");
        double[] recent = (double[])Reflection.getField((Field)recentTpsField, (Object)server);
        return Math.min((double)Math.round(recent[0] * 100.0) / 100.0, 20.0);
    }

    public static String getFormattedTPS() {
        Class minecraftServerClass = Reflection.getNMSClass((String)"MinecraftServer");
        Method getServerMethod = Reflection.makeMethod((Class)minecraftServerClass, (String)"getServer", (Class[])new Class[0]);
        Object server = Reflection.callMethod((Method)getServerMethod, null, (Object[])new Object[0]);
        Field recentTpsField = Reflection.makeField((Class)minecraftServerClass, (String)"recentTps");
        double[] recent = (double[])Reflection.getField((Field)recentTpsField, (Object)server);
        return ServerUtil.transformTPS(recent[0]);
    }

    private static String transformTPS(double tps) {
        return (tps > 16.0 ? ChatColor.YELLOW : (tps > 18.0 ? ChatColor.GREEN : ChatColor.RED)).toString() + (tps > 20.0 ? "+" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }

    public static String getTimeUTC() {
        return ServerUtil.getTimeUTC(0);
    }

    public static String getTimeUTC(int decalage) {
        ZonedDateTime utc = ZonedDateTime.now(ZoneOffset.UTC);
        if (decalage > 0) {
            utc = utc.plusHours(decalage);
        }
        if (decalage < 0) {
            utc = utc.minusHours(decalage * -1);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        return utc.format(formatter);
    }

    public static HashMap<String, String> getCommands(Player player) {
        HashMap<String, String> commands = new HashMap<String, String>();
        for (HelpTopic help : Bukkit.getServer().getHelpMap().getHelpTopics()) {
            String name;
            if (!(help instanceof IndexHelpTopic) || !(name = help.getName()).equals("SupUHC")) continue;
            String text = help.getFullText((CommandSender)player);
            for (int i = 0; i < text.split("\n").length; ++i) {
                if (i == 0) continue;
                String cmd = ChatColor.stripColor((String)text.split("\n")[i]).split(": ")[0];
                String desc = ChatColor.stripColor((String)text.split("\n")[i]).split(": ")[1];
                if (commands.entrySet().stream().anyMatch(e -> ((String)e.getValue()).contains(desc))) {
                    Map.Entry mainInfo = commands.entrySet().stream().filter(e -> ((String)e.getValue()).contains(desc)).findFirst().orElse(null);
                    String newDesc = (String)mainInfo.getValue();
                    newDesc = !newDesc.contains("Aliases: ") ? newDesc + " // " + ChatColor.GRAY + "Aliases: " + ChatColor.AQUA + cmd : newDesc + ", " + cmd;
                    commands.put((String)mainInfo.getKey(), newDesc);
                    continue;
                }
                commands.put(cmd, desc);
            }
        }
        return commands;
    }

    public static int getCommandsSize(Player player) {
        int commands = ServerUtil.getCommands(player).size();
        return (int)Math.min(Math.ceil((double)commands / 45.0), 6.0);
    }

    public static long getUsedRam() {
        long value = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory();
        return value / 0x100000L;
    }

    public static long getMaxRam() {
        long value = Runtime.getRuntime().maxMemory();
        return value / 0x100000L;
    }
}

