/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.server;

import com.google.common.collect.Iterables;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayInClientCommand;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityStatus;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PacketUtil {
    public static void sendRespawn(Player p) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)UHC.getInstance(), () -> ((CraftPlayer)p).getHandle().playerConnection.a(new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.PERFORM_RESPAWN)), 10L);
    }

    public static void sendConnect(Player p, String server) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("Connect");
            out.writeUTF(server);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        p.sendPluginMessage((Plugin)UHC.getInstance(), "BungeeCord", b.toByteArray());
    }

    public static void broadcastMessage(Player sender, String message) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("Message");
            out.writeUTF("ALL");
            out.writeUTF(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sender == null) {
            sender = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        }
        sender.sendPluginMessage((Plugin)UHC.getInstance(), "BungeeCord", b.toByteArray());
    }

    public static void changeCoords(Player p) {
        if (Values.CHAT_COORDS.getBoolean()) {
            PacketUtil.enableCoords(p);
        } else {
            PacketUtil.disableCoords(p);
        }
    }

    private static void disableCoords(Player p) {
        try {
            EntityPlayer cp = ((CraftPlayer)p).getHandle();
            PacketPlayOutEntityStatus packetC = new PacketPlayOutEntityStatus((net.minecraft.server.v1_8_R3.Entity)cp, Byte.valueOf((byte)22).byteValue());
            cp.playerConnection.sendPacket((Packet)packetC);
        }
        catch (Exception e) {
            System.out.println("[ERROR] Disable Coords: " + e.getMessage());
        }
    }

    private static void enableCoords(Player p) {
        try {
            EntityPlayer cp = ((CraftPlayer)p).getHandle();
            PacketPlayOutEntityStatus packetC = new PacketPlayOutEntityStatus((net.minecraft.server.v1_8_R3.Entity)cp, Byte.valueOf((byte)23).byteValue());
            cp.playerConnection.sendPacket((Packet)packetC);
        }
        catch (Exception e) {
            System.out.println("[ERROR] Enable Coords: " + e.getMessage());
        }
    }

    public static void disableAI(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity nmsEnt = ((CraftEntity)entity).getHandle();
        NBTTagCompound tag = nmsEnt.getNBTTag();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        nmsEnt.c(tag);
        tag.setInt("NoAI", 1);
        nmsEnt.f(tag);
    }

    public static void hideArmor(Player player) {
        if (player == null || player.getInventory() == null) {
            return;
        }
        int id = player.getEntityId();
        PacketPlayOutEntityEquipment helmet = new PacketPlayOutEntityEquipment(id, 1, null);
        PacketPlayOutEntityEquipment chestplate = new PacketPlayOutEntityEquipment(id, 2, null);
        PacketPlayOutEntityEquipment leggings = new PacketPlayOutEntityEquipment(id, 3, null);
        PacketPlayOutEntityEquipment boots = new PacketPlayOutEntityEquipment(id, 4, null);
        PacketPlayOutEntityEquipment itemHand = new PacketPlayOutEntityEquipment(id, 0, null);
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (online == player) continue;
            try {
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)helmet);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)chestplate);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)leggings);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)boots);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)itemHand);
            }
            catch (Exception e) {
                System.out.println("(PacketUtil) Error with hideArmor(Player)");
                e.printStackTrace();
            }
        }
    }

    public static void showArmor(Player player) {
        if (player == null || player.getInventory() == null) {
            return;
        }
        int id = player.getEntityId();
        PacketPlayOutEntityEquipment helmet = new PacketPlayOutEntityEquipment(id, 1, CraftItemStack.asNMSCopy((ItemStack)player.getInventory().getHelmet()));
        PacketPlayOutEntityEquipment chestplate = new PacketPlayOutEntityEquipment(id, 2, CraftItemStack.asNMSCopy((ItemStack)player.getInventory().getChestplate()));
        PacketPlayOutEntityEquipment leggings = new PacketPlayOutEntityEquipment(id, 3, CraftItemStack.asNMSCopy((ItemStack)player.getInventory().getLeggings()));
        PacketPlayOutEntityEquipment boots = new PacketPlayOutEntityEquipment(id, 4, CraftItemStack.asNMSCopy((ItemStack)player.getInventory().getBoots()));
        PacketPlayOutEntityEquipment itemHand = new PacketPlayOutEntityEquipment(id, 0, CraftItemStack.asNMSCopy((ItemStack)player.getItemInHand()));
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (online == player) continue;
            try {
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)helmet);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)chestplate);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)leggings);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)boots);
                ((CraftPlayer)online).getHandle().playerConnection.sendPacket((Packet)itemHand);
            }
            catch (Exception e) {
                System.out.println("(PacketUtil) Error with showArmor(Player)");
                e.printStackTrace();
            }
        }
    }
}

