/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.player;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.GameDeathEvent;
import eu.scorpionltd.uhc.events.custom.player.GameReviveEvent;
import eu.scorpionltd.uhc.events.custom.whitelist.WhitelistAddEvent;
import eu.scorpionltd.uhc.events.custom.whitelist.WhitelistRemoveEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.infos.PlayerInventory;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.scoreboard.ScoreboardLife;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.player.MovementUtil;
import eu.scorpionltd.uhc.util.server.PacketUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.world.TeleportationUtil;
import eu.scorpionltd.uhc.util.world.monde.ArenaUtil;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PlayerUtil {
    private static final BlockFace[] axis = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private static final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};

    public static void returnHub(UHCPlayer player) {
        Player p = player.getPlayer();
        if (ConfigFile.BUNGEE_ENABLE.getBoolean() && ConfigFile.BUNGEE_KICK_PLAYER_SERV.getString() != "") {
            PacketUtil.sendConnect(p, ConfigFile.BUNGEE_KICK_PLAYER_SERV.getString());
        } else {
            p.kickPlayer(MEnum.KICK_MESSAGE.getText(player, player.getName()));
        }
    }

    public static void addWhitelist(CommandSender sender, OfflinePlayer target) {
        target.setWhitelisted(true);
        Bukkit.getPluginManager().callEvent((Event)new WhitelistAddEvent(target, sender));
        if (sender != null && sender instanceof Player) {
            MEnum.WHITELIST_ADD.sendTo((Player)sender, target.getName());
        }
        System.out.println("WHITELIST: + " + target.getName());
    }

    public static void removeWhitelist(CommandSender sender, OfflinePlayer target) {
        target.setWhitelisted(false);
        Bukkit.getPluginManager().callEvent((Event)new WhitelistRemoveEvent(target, sender));
        if (sender != null && sender instanceof Player) {
            MEnum.WHITELIST_REMOVE.sendTo((Player)sender, target.getName());
        }
        System.out.println("WHITELIST: - " + target.getName());
    }

    public static void revivePlayer(final Player player, PlayerInventory playerInventory) {
        final UHCPlayer uhcPlayer = UHCPlayerManager.getPlayer(player.getUniqueId());
        uhcPlayer.setDead(false);
        uhcPlayer.setPlaying(true);
        Location lastLoc = uhcPlayer.getInventory().getLocation();
        if (lastLoc != null && ConfigFile.SPECS_REVIVE_REMOVE_DROPS.getBoolean()) {
            double rayon = 5.0;
            for (Entity ent : lastLoc.getWorld().getNearbyEntities(lastLoc, rayon, rayon, rayon)) {
                if (!(ent instanceof Item)) continue;
                ent.remove();
            }
        }
        player.teleport(ArenaUtil.getArenaWorld().getHighestBlockAt(TeleportationUtil.createGameSpawnLocation()).getLocation().add(0.5, 1.0, 0.5));
        player.setGameMode(GameMode.SURVIVAL);
        player.setWalkSpeed(0.2f);
        player.setDisplayName(player.getDisplayName());
        player.setPlayerListName(player.getName());
        UHCTeam team = UHC.getTeam(player);
        if (team != null) {
            team.sendDisplay(uhcPlayer);
        }
        playerInventory.givePlayer(player);
        Metadata.NO_DAMAGE.add(player);
        new Cooldown(10){

            public void onFinish() {
                Metadata.NO_DAMAGE.remove(player);
                Bukkit.getPluginManager().callEvent((Event)new GameReviveEvent(uhcPlayer));
            }
        };
        ScoreboardLife.updateHealth(player);
    }

    public static void revivePlayer(Player player) {
        PlayerUtil.revivePlayer(player, UHCPlayerManager.getPlayer(player.getUniqueId()).getInventory());
    }

    public static void latescatterPlayer(final Player p) {
        final UHCPlayer up = UHCPlayerManager.getPlayer(p.getUniqueId());
        up.setDead(false);
        up.setDeconnecting(false);
        up.setPlaying(true);
        up.setSpec(false);
        UHC.getScoreboard().fillClassement(p);
        p.teleport(ArenaUtil.getArenaWorld().getHighestBlockAt(TeleportationUtil.createGameSpawnLocation()).getLocation().add(0.5, 1.0, 0.5));
        p.setWhitelisted(true);
        p.setDisplayName(p.getDisplayName());
        p.setPlayerListName(p.getName());
        p.setHealth(20.0);
        p.setGameMode(GameMode.SURVIVAL);
        if (!Values.TEAM_FFA.getBoolean()) {
            UHC.getTeamManager().joinRandomTeam(up);
        }
        p.getInventory().clear();
        Values.INVENTORY_START.getListItemStack().forEach(item -> InventoryUtil.addItem(p, item));
        p.updateInventory();
        p.setWalkSpeed(0.2f);
        p.setFoodLevel(20);
        ScoreboardLife.updateHealth(p);
        MovementUtil.unfreeze(p);
        PacketUtil.changeCoords(p);
        Metadata.NO_DAMAGE.add(p);
        new Cooldown(5){

            public void onFinish() {
                Metadata.NO_DAMAGE.remove(p);
                Bukkit.getPluginManager().callEvent((Event)new GameReviveEvent(up));
            }
        };
        ScoreboardLife.updateHealth(p);
    }

    public static void giveDeathSpecs(GameDeathEvent event) {
        UHCPlayer death = event.getDeath();
        Location loc = death.getPlayer().getLocation();
        Player killer = event.getDeathEvent().getEntity().getKiller();
        if (killer == null) {
            UHC.getScoreboard().addPVE();
        }
        if (Values.RULES_LIGHTNING.getBoolean()) {
            death.getPlayer().getWorld().strikeLightningEffect(loc);
        }
        if (Values.RULES_HEAD_POST.getBoolean()) {
            loc.getBlock().setType(Material.NETHER_FENCE);
            Block block = loc.getBlock().getRelative(BlockFace.UP);
            block.setType(Material.SKULL);
            block.setData((byte)1);
            BlockState state = block.getState();
            if (state instanceof Skull) {
                Skull skull = (Skull)state;
                skull.setRotation(BlockFace.NORTH);
                skull.setOwner(death.getName());
                skull.setSkullType(SkullType.PLAYER);
                skull.update();
            }
        }
        if (Values.RULES_SOUND.getBoolean()) {
            for (Player pl : Bukkit.getOnlinePlayers()) {
                pl.getWorld().playSound(pl.getLocation(), Sound.WITHER_SPAWN, 1.0f, 1.0f);
            }
        }
    }

    public static List<UHCPlayer> getNearUHCPlayers(double rayon, Player p) {
        ArrayList<UHCPlayer> joueurs = new ArrayList<UHCPlayer>();
        for (Entity ent : p.getNearbyEntities(rayon, rayon, rayon)) {
            UHCPlayer target;
            if (!(ent instanceof Player) || !(target = UHCPlayerManager.getPlayer(ent.getUniqueId())).isPlaying()) continue;
            joueurs.add(target);
        }
        return joueurs;
    }

    public static List<Player> getNearPlayers(double rayon, Player p) {
        ArrayList<Player> joueurs = new ArrayList<Player>();
        for (Entity ent : p.getNearbyEntities(rayon, rayon, rayon)) {
            Player target;
            if (!(ent instanceof Player) || !UHCPlayerManager.getPlayer((target = (Player)ent).getUniqueId()).isPlaying()) continue;
            joueurs.add(target);
        }
        return joueurs;
    }

    public static List<Player> getNearPlayers(double rayon, Location loc) {
        ArrayList<Player> joueurs = new ArrayList<Player>();
        for (Entity ent : loc.getWorld().getNearbyEntities(loc, rayon, rayon, rayon)) {
            Player target;
            if (!(ent instanceof Player) || !UHCPlayerManager.getPlayer((target = (Player)ent).getUniqueId()).isPlaying()) continue;
            joueurs.add(target);
        }
        return joueurs;
    }

    public static List<Player> getNearAllies(double rayon, Player p) {
        ArrayList<Player> joueurs = new ArrayList<Player>();
        for (Entity ent : p.getNearbyEntities(rayon, rayon, rayon)) {
            Player target;
            if (!(ent instanceof Player) || !UHCPlayerManager.getPlayer((target = (Player)ent).getUniqueId()).isPlaying() || !UHC.isSameTeam(p, target)) continue;
            joueurs.add(target);
        }
        return joueurs;
    }

    public static List<Player> getNearEnnemies(double rayon, Player p) {
        ArrayList<Player> joueurs = new ArrayList<Player>();
        for (Entity ent : p.getNearbyEntities(rayon, rayon, rayon)) {
            Player target;
            if (!(ent instanceof Player) || !UHCPlayerManager.getPlayer((target = (Player)ent).getUniqueId()).isPlaying() || UHC.isSameTeam(p, target)) continue;
            joueurs.add(target);
        }
        return joueurs;
    }

    public static int getPing(Player player) {
        return ((CraftPlayer)player).getHandle().ping;
    }

    public static void sendDirectionalArrow(UHCPlayer player, Set<UHCPlayer> targets) {
        if (targets.isEmpty()) {
            return;
        }
        Location playerLoc = player.getPlayer().getLocation();
        String infos = "";
        for (UHCPlayer target : targets) {
            if (player == target || target.getPlayer() == null) continue;
            Location targetLoc = target.getPlayer().getLocation();
            if (playerLoc.getWorld() != targetLoc.getWorld()) continue;
            infos = infos + ChatColor.YELLOW + target.getName() + " " + ChatColor.AQUA + PlayerUtil.getDistanceBlocks(playerLoc, targetLoc) + " " + ChatColor.GRAY + PlayerUtil.getDirectionalArrow(playerLoc, targetLoc) + ChatColor.DARK_GRAY + " | ";
        }
        if (infos.equals("") || infos.length() < 3) {
            return;
        }
        player.getScorpionPlayer().getPlayerPacket().sendActionBar(infos.substring(0, infos.length() - 3));
    }

    public static void sendDirectionalArrow(UHCPlayer player, List<UHCPlayer> targets) {
        if (targets.isEmpty()) {
            return;
        }
        Location playerLoc = player.getPlayer().getLocation();
        String infos = "";
        for (UHCPlayer target : targets) {
            if (player == target || target.getPlayer() == null) continue;
            Location targetLoc = target.getPlayer().getLocation();
            if (playerLoc.getWorld() != targetLoc.getWorld()) continue;
            infos = infos + ChatColor.YELLOW + target.getName() + " " + ChatColor.AQUA + PlayerUtil.getDistanceBlocks(playerLoc, targetLoc) + " " + ChatColor.GRAY + PlayerUtil.getDirectionalArrow(playerLoc, targetLoc) + ChatColor.DARK_GRAY + " | ";
        }
        if (infos == "") {
            return;
        }
        player.getScorpionPlayer().getPlayerPacket().sendActionBar(infos.substring(0, infos.length() - 3));
    }

    public static void sendDirectionalArrow(UHCPlayer player, UHCPlayer ... targets) {
        if (targets.length == 0) {
            return;
        }
        Location playerLoc = player.getPlayer().getLocation();
        String infos = "";
        for (UHCPlayer target : targets) {
            if (player == target || target.getPlayer() == null) continue;
            Location targetLoc = target.getPlayer().getLocation();
            if (playerLoc.getWorld() != targetLoc.getWorld()) continue;
            infos = infos + ChatColor.YELLOW + target.getName() + " " + ChatColor.AQUA + PlayerUtil.getDistanceBlocks(playerLoc, targetLoc) + " " + ChatColor.GRAY + PlayerUtil.getDirectionalArrow(playerLoc, targetLoc) + ChatColor.DARK_GRAY + " | ";
        }
        if (infos.equals("")) {
            return;
        }
        player.getScorpionPlayer().getPlayerPacket().sendActionBar(infos.substring(0, infos.length() - 3));
    }

    public static void sendDirectionalBlocks(UHCPlayer player, UHCPlayer ... targets) {
        Location playerLoc = player.getPlayer().getLocation();
        String infos = "";
        for (UHCPlayer target : targets) {
            if (player == target || target.getPlayer() == null) continue;
            Location targetLoc = target.getPlayer().getLocation();
            if (playerLoc.getWorld() != targetLoc.getWorld()) continue;
            infos = infos + ChatColor.YELLOW + target.getName() + " " + ChatColor.AQUA + PlayerUtil.getDistanceBlocks(playerLoc, targetLoc) + ChatColor.DARK_GRAY + " | ";
        }
        if (infos.equals("")) {
            return;
        }
        player.getScorpionPlayer().getPlayerPacket().sendActionBar(infos.substring(0, infos.length() - 3));
    }

    public static int getDistanceBlocks(Location loc1, Location loc2) {
        return (int)Math.round(loc1.distance(loc2));
    }

    public static String getDirectionalArrow(Location playerLoc, Location targetLoc) {
        Vector playerToEntity = targetLoc.clone().subtract(playerLoc).toVector();
        Vector playerLooking = playerLoc.getDirection();
        double x1 = playerToEntity.getX();
        double z1 = playerToEntity.getZ();
        double x2 = playerLooking.getX();
        double z2 = playerLooking.getZ();
        double angle = Math.atan2(x1 * z2 - z1 * x2, x1 * x2 + z1 * z2) * 180.0 / Math.PI;
        if (angle >= -15.0 && angle <= 15.0) {
            return "\u2b06";
        }
        if (angle > 15.0 && angle < 75.0) {
            return "\u2b09";
        }
        if (angle >= 75.0 && angle <= 105.0) {
            return "\u2190";
        }
        if (angle > 105.0 && angle < 165.0) {
            return "\u2b0b";
        }
        if (angle >= 165.0 || angle <= -165.0) {
            return "\u2b07";
        }
        if (angle > -165.0 && angle < -105.0) {
            return "\u2b0a";
        }
        if (angle >= -105.0 || angle <= -75.0) {
            return "\u27a1";
        }
        return "\u2b08";
    }

    public static BlockFace yawToFace(float yaw, boolean useSubCardinalDirections) {
        if (useSubCardinalDirections) {
            return radial[Math.round(yaw / 45.0f) & 7].getOppositeFace();
        }
        return axis[Math.round(yaw / 90.0f) & 3].getOppositeFace();
    }

    public static final BlockFace[] getAxis() {
        return axis;
    }

    public static final BlockFace[] getRadial() {
        return radial;
    }
}

