/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.player;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.util.player.EffectUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class MovementUtil {
    public static void freeze(Player p) {
        if (p == null) {
            return;
        }
        EffectUtil.giveInfiniteEffect(p, PotionEffectType.BLINDNESS, 250);
        EffectUtil.giveInfiniteEffect(p, PotionEffectType.SLOW, 10);
        EffectUtil.giveInfiniteEffect(p, PotionEffectType.JUMP, 250);
        p.setWalkSpeed(0.0f);
    }

    public static void unfreeze(Player p) {
        if (p == null) {
            return;
        }
        EffectUtil.removeEffect(p, PotionEffectType.BLINDNESS);
        EffectUtil.removeEffect(p, PotionEffectType.SLOW);
        EffectUtil.removeEffect(p, PotionEffectType.JUMP);
        p.setWalkSpeed(0.2f);
    }

    public static void freezeAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            MovementUtil.freeze(p);
        }
    }

    public static void unfreezeAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            MovementUtil.unfreeze(p);
        }
    }

    public static void refreshVisible() {
        for (final Player p : Bukkit.getOnlinePlayers()) {
            for (Player pl : Bukkit.getOnlinePlayers()) {
                p.hidePlayer(pl);
                pl.hidePlayer(p);
            }
            new BukkitRunnable(){

                public void run() {
                    if (!p.isValid()) {
                        return;
                    }
                    for (Player pl : Bukkit.getOnlinePlayers()) {
                        p.showPlayer(pl);
                        pl.showPlayer(p);
                    }
                }
            }.runTaskLater((Plugin)UHC.getInstance(), 10L);
        }
    }
}

