/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.player;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.connexion.LobbyReceivedItemsEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.utils.item.Item;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryUtil {
    public static void addItem(Player player, ItemStack item) {
        if (player == null || item == null) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        if (inv == null || InventoryUtil.isFull(player)) {
            if (inv.containsAtLeast(item, 1)) {
                inv.addItem(new ItemStack[]{item});
                if (player != null) {
                    player.updateInventory();
                }
                return;
            }
            MEnum.FULL_INV.sendTo(player, new Object[0]);
            UHCPlayer uhcPlayer = UHCPlayerManager.getPlayer(player);
            uhcPlayer.getInventory().addItemFullBackpack(item.clone());
        } else {
            inv.addItem(new ItemStack[]{item});
            if (player != null) {
                player.updateInventory();
            }
        }
    }

    public static void removeItem(Player player, ItemStack item) {
        if (player == null || item == null) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        if (inv == null || !inv.contains(item)) {
            return;
        }
        inv.removeItem(new ItemStack[]{item});
        if (player != null) {
            player.updateInventory();
        }
    }

    public static void dropItem(Location loc, ItemStack item) {
        loc.getWorld().dropItem(loc.clone().add(0.5, 0.3, 0.5), item);
    }

    public static boolean haveGoodItem(ItemStack item, Block block) {
        if (item.getType() == Material.SHEARS && (block.getType() == Material.LEAVES || block.getType() == Material.LEAVES_2)) {
            return true;
        }
        return !block.getDrops(item).isEmpty();
    }

    public static void giveJoinItems(UHCPlayer p) {
        Player player = p.getPlayer();
        player.getInventory().clear();
        if (UHC.getTeamManager().canTeamSelection()) {
            Item teamSelection = new Item(ConfigFile.ITEMS_TEAMS.getItemStack());
            teamSelection.setName(MEnum.CHOOSE_TEAM_ITEM.getText(p, new Object[0]));
            if (UHC.getTeam(p) != null && teamSelection.getMaterial() == Material.BANNER) {
                teamSelection.setDurabilite(UHC.getTeam(p).getPrefix().getColor().getBlock());
            }
            player.getInventory().setItem(0, teamSelection.toItemStackwithItemFlag(ItemFlag.values()));
        }
        if (Permissions.GIVE_CONFIG_ITEM.hasPerm(p.getPlayer())) {
            Item configMenu = new Item(ConfigFile.ITEMS_CONFIG.getItemStack());
            configMenu.setName(MEnum.CONFIG_HOST_ITEM.getText(p, new Object[0]));
            player.getInventory().setItem(4, configMenu.toItemStackwithItemFlag(ItemFlag.values()));
        }
        Item settings = new Item(ConfigFile.ITEMS_PROFILE.getItemStack());
        settings.setName(MEnum.PROFIL_ITEM.getText(p, new Object[0]));
        if (settings.getMaterial() == Material.SKULL_ITEM && settings.getDurabilite() == 3) {
            player.getInventory().setItem(6, settings.toItemStackwithSkull(p.getName()));
        } else {
            player.getInventory().setItem(6, settings.toItemStackwithItemFlag(ItemFlag.values()));
        }
        Item returnHub = new Item(ConfigFile.ITEMS_HUB.getItemStack());
        returnHub.setName(MEnum.LOBBY_ITEM.getText(p, new Object[0]));
        player.getInventory().setItem(8, returnHub.toItemStackwithItemFlag(ItemFlag.values()));
        player.updateInventory();
        Bukkit.getPluginManager().callEvent((Event)new LobbyReceivedItemsEvent(p));
    }

    public static void giveAllJoinItems() {
        Bukkit.getOnlinePlayers().forEach(pl -> InventoryUtil.giveJoinItems(UHCPlayerManager.getPlayer(pl)));
    }

    public static boolean isFull(Player player) {
        return player.getInventory().firstEmpty() == -1;
    }

    public static void saveStuff(Player player) {
        UHCPlayer uhcPlayer = UHCPlayerManager.getPlayer(player);
        uhcPlayer.getInventory().savePlayer(player);
    }

    public static void dropDeathStuff(UHCPlayer uhcPlayer, Location location) {
        uhcPlayer.getInventory().dropPlayer(location);
    }

    public static boolean hasNoArmor(Player p) {
        return p.getInventory().getHelmet() == null && p.getInventory().getChestplate() == null && p.getInventory().getLeggings() == null && p.getInventory().getBoots() == null;
    }

    public static boolean hasFullArmor(Player p) {
        return p.getInventory().getHelmet() != null && p.getInventory().getChestplate() != null && p.getInventory().getLeggings() != null && p.getInventory().getBoots() != null;
    }

    public static boolean haveItemInHand(Player p) {
        return p.getItemInHand() != null && p.getItemInHand().getType() != null && p.getItemInHand().getType() != Material.AIR;
    }

    public static void fillInventory(Inventory inv, List<ItemStack> stack) {
        for (ItemStack i : stack) {
            if (i == null || i.getType() == Material.AIR) continue;
            inv.addItem(new ItemStack[]{i});
        }
    }

    public static int countMaterial(Inventory inv, Material material) {
        int number = 0;
        for (ItemStack item : inv.getContents()) {
            if (item == null || item.getType() == null || item.getAmount() <= 0 || item.getType() != material) continue;
            number += item.getAmount();
        }
        return number;
    }

    public static int getNumberItemsInInventory(Player player) {
        if (player == null || player.getInventory() == null || player.getInventory().getContents() == null) {
            return 0;
        }
        int result = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == null) continue;
            ++result;
        }
        return result;
    }
}

