/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.player;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.scoreboard.ScoreboardLife;
import eu.scorpionltd.uhc.util.server.PacketUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class EffectUtil {
    public static void setHealth(Player player, double amount) {
        if (player == null) {
            return;
        }
        if (amount > player.getMaxHealth()) {
            player.setHealth(player.getMaxHealth());
        } else {
            player.setHealth(amount);
        }
        ScoreboardLife.updateHealth(player);
    }

    public static void addHealth(Player player, double amount) {
        if (player == null) {
            return;
        }
        double newHealth = player.getHealth() + amount;
        if (newHealth >= player.getMaxHealth()) {
            newHealth = player.getMaxHealth();
        }
        player.setHealth(newHealth);
        ScoreboardLife.updateHealth(player);
    }

    public static void removeHealth(Player player, double amount, boolean notKill) {
        if (player == null) {
            return;
        }
        double newAmount = player.getHealth() - amount;
        if (newAmount < 0.0) {
            if (notKill) {
                player.setHealth(1.0);
            } else {
                EffectUtil.kill(player);
            }
        } else if (newAmount >= player.getMaxHealth()) {
            player.setHealth(player.getMaxHealth());
        } else {
            player.setHealth(newAmount);
        }
        ScoreboardLife.updateHealth(player);
    }

    public static void removeHealth(Player player, double amount) {
        EffectUtil.removeHealth(player, amount, false);
    }

    public static void addMaxHealth(Player player, int coeurs, boolean filled) {
        EffectUtil.addMaxHealth(player, (double)coeurs * 2.0, filled);
    }

    public static void addMaxHealth(Player player, double coeurs, boolean filled) {
        if (player == null) {
            return;
        }
        player.setMaxHealth(player.getMaxHealth() + coeurs);
        if (filled) {
            player.setHealth(player.getHealth() + coeurs);
        }
        ScoreboardLife.updateHealth(player);
    }

    public static void removeMaxHealth(Player player, int coeurs) {
        EffectUtil.removeMaxHealth(player, (double)coeurs * 2.0);
    }

    public static void removeMaxHealth(Player player, double coeurs) {
        if (player == null) {
            return;
        }
        if (player.getHealth() >= player.getMaxHealth() - coeurs) {
            player.setHealth(player.getMaxHealth() - coeurs);
        }
        player.setMaxHealth(player.getMaxHealth() - coeurs);
        ScoreboardLife.updateHealth(player);
    }

    public static void removeMaxHealthCooldown(final Player player, final int coeurs, final int time) {
        EffectUtil.removeMaxHealth(player, coeurs);
        new BukkitRunnable(){
            private int cooldown;
            private UUID uuid;
            {
                this.cooldown = time;
                this.uuid = player.getUniqueId();
            }

            public void run() {
                if (this.cooldown <= 0) {
                    Player newPlayer = Bukkit.getPlayer((UUID)this.uuid);
                    if (newPlayer == null || !newPlayer.isOnline()) {
                        return;
                    }
                    this.cancel();
                    EffectUtil.addMaxHealth(newPlayer, coeurs, false);
                    return;
                }
                --this.cooldown;
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
    }

    public static void damage(Player player, double amount) {
        if (player == null) {
            return;
        }
        player.damage(amount);
        ScoreboardLife.updateHealth(player);
    }

    public static void kill(Player p) {
        EffectUtil.damage(p, 9999.0);
    }

    public static void heal(Player player) {
        if (player == null) {
            return;
        }
        player.setHealth(player.getMaxHealth());
        ScoreboardLife.updateHealth(player);
    }

    public static void healAll() {
        Bukkit.getOnlinePlayers().forEach(pl -> EffectUtil.heal(pl));
    }

    public static void feed(Player player) {
        if (player == null) {
            return;
        }
        player.setFoodLevel(20);
    }

    public static void feedAll() {
        Bukkit.getOnlinePlayers().forEach(pl -> EffectUtil.feed(pl));
    }

    public static void setAbsoHearths(Player player, int coeur) {
        if (player == null) {
            return;
        }
        ((CraftPlayer)player).getHandle().setAbsorptionHearts((float)coeur);
    }

    public static double getAbsoHearths(Player player) {
        if (player == null) {
            return 0.0;
        }
        return ((CraftPlayer)player).getHandle().getAbsorptionHearts();
    }

    public static void slow(Player player) {
        EffectUtil.giveEffect(player, PotionEffectType.SLOW, 60, 1, false);
    }

    public static void slowAll() {
        Bukkit.getOnlinePlayers().forEach(pl -> EffectUtil.slow(pl));
    }

    public static void removeEffect(Player player, PotionEffectType type) {
        if (player == null) {
            return;
        }
        if (player.hasPotionEffect(type)) {
            player.removePotionEffect(type);
        }
    }

    public static void resetEffect(Player player) {
        if (player.getActivePotionEffects() != null) {
            for (PotionEffect potion : player.getActivePotionEffects()) {
                player.removePotionEffect(potion.getType());
            }
        }
        Metadata.NO_FALL.remove(player);
    }

    public static void giveEffectTicks(Player player, PotionEffectType type, int ticks, int level, boolean particles) {
        EffectUtil.removeEffect(player, type);
        if (player == null) {
            return;
        }
        player.addPotionEffect(new PotionEffect(type, ticks, level - 1, particles, particles));
    }

    public static void giveEffect(Player player, PotionEffectType type, int seconds, int level, boolean particles) {
        EffectUtil.removeEffect(player, type);
        if (player == null) {
            return;
        }
        player.addPotionEffect(new PotionEffect(type, 20 * seconds, level - 1, particles, particles));
    }

    public static void giveEffect(Player player, PotionEffectType type, int seconds, int level) {
        EffectUtil.giveEffect(player, type, seconds, level, false);
    }

    public static void giveInfiniteEffect(Player player, PotionEffectType type, int level, boolean particles) {
        EffectUtil.giveEffect(player, type, 50000, level, particles);
    }

    public static void giveInfiniteEffect(Player player, PotionEffectType type, int level) {
        EffectUtil.giveEffect(player, type, 50000, level, false);
    }

    public static void giveInvisibleArmor(Player player, final int secondes) {
        final UUID uuid = player.getUniqueId();
        EffectUtil.setInvisibleArmor(player);
        new BukkitRunnable(){
            int cooldown;
            {
                this.cooldown = secondes;
            }

            public void run() {
                Player connected = Bukkit.getPlayer((UUID)uuid);
                if (connected != null && connected.isOnline() && !Metadata.INVISIBLE_ARMOR.has(connected)) {
                    this.cancel();
                    PacketUtil.showArmor(connected);
                    return;
                }
                if (this.cooldown <= 0 && connected != null && connected.isOnline()) {
                    this.cancel();
                    EffectUtil.unsetInvisibleArmor(connected);
                    return;
                }
                if (connected != null && connected.isOnline()) {
                    PacketUtil.hideArmor(connected);
                }
                --this.cooldown;
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
    }

    public static void setInvisibleArmor(Player player) {
        Metadata.INVISIBLE_ARMOR.add(player);
        PacketUtil.hideArmor(player);
    }

    public static void unsetInvisibleArmor(Player player) {
        Metadata.INVISIBLE_ARMOR.remove(player);
        PacketUtil.showArmor(player);
    }

    public static void freezeEffect(Player player, int seconds) {
        Metadata.NO_FALL.addCooldown(player, seconds);
        EffectUtil.giveEffect(player, PotionEffectType.SLOW, seconds, 11);
        EffectUtil.giveEffect(player, PotionEffectType.JUMP, seconds, -10);
    }

    public static void stunPlayer(Player player, int seconds) {
        Metadata.NO_JUMP.addCooldown(player, seconds);
        EffectUtil.giveEffect(player, PotionEffectType.SLOW, seconds, 11);
    }
}

