/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.item;

import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.chat.color.Colors;
import eu.scorpionltd.uhc.util.item.EnchantLevel;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.utils.item.Item;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemUtil {
    public static ItemStack getGoldenHead() {
        Item item = new Item(Material.GOLDEN_APPLE, 1, ChatColor.GOLD + "Golden Head");
        item.setLore(new String[]{ChatColor.GRAY + "Regeneration 4 hearts"});
        return item.toItemStack().clone();
    }

    public static ItemStack getHead(String name) {
        ItemStack item = new ItemStack(Material.SKULL_ITEM, 1, 3);
        SkullMeta itemMeta = (SkullMeta)item.getItemMeta();
        itemMeta.setDisplayName(ChatColor.AQUA + name);
        itemMeta.setOwner(name);
        item.setItemMeta((ItemMeta)itemMeta);
        return item;
    }

    public static ItemStack getVersionItem() {
        Item version = new Item(Material.REDSTONE_LAMP_OFF, ChatColor.GREEN + "ScorpionLTD-UHC");
        version.setLore(new String[]{ChatColor.YELLOW + "Type " + ChatUtil.getArrow() + ChatUtil.getVersionType(), "", ChatColor.YELLOW + "Cr\u00e9\u00e9 par", Colors.AQUA.getText() + "ScorpionLTD"});
        return version.toItemStack();
    }

    public static ItemStack getTier1Book() {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, 1);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
        int random = new Random().nextInt(9) + 1;
        switch (random) {
            case 1: {
                meta.addStoredEnchant(Enchantment.ARROW_INFINITE, 1, true);
                break;
            }
            case 2: {
                meta.addStoredEnchant(Enchantment.KNOCKBACK, 1, true);
                break;
            }
            case 3: {
                meta.addStoredEnchant(Enchantment.THORNS, 1, true);
                break;
            }
            case 4: {
                meta.addStoredEnchant(Enchantment.PROTECTION_PROJECTILE, 1, true);
                break;
            }
            case 5: {
                meta.addStoredEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 1, true);
                break;
            }
            case 6: {
                meta.addStoredEnchant(Enchantment.DAMAGE_ALL, 1, true);
                break;
            }
            case 8: {
                meta.addStoredEnchant(Enchantment.ARROW_DAMAGE, 1, true);
                break;
            }
            case 9: {
                meta.addStoredEnchant(Enchantment.ARROW_DAMAGE, 1, true);
            }
        }
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public static ItemStack getRandomEnchantedBook() {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, 1);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
        int random = new Random().nextInt(19) + 1;
        switch (random) {
            case 1: {
                meta.addStoredEnchant(Enchantment.ARROW_INFINITE, 1, true);
                break;
            }
            case 2: {
                meta.addStoredEnchant(Enchantment.ARROW_FIRE, 1, true);
                break;
            }
            case 3: {
                meta.addStoredEnchant(Enchantment.FIRE_ASPECT, 1, true);
                break;
            }
            case 4: {
                meta.addStoredEnchant(Enchantment.FIRE_ASPECT, 2, true);
                break;
            }
            case 5: {
                meta.addStoredEnchant(Enchantment.KNOCKBACK, 1, true);
                break;
            }
            case 6: {
                meta.addStoredEnchant(Enchantment.KNOCKBACK, 2, true);
                break;
            }
            case 7: {
                meta.addStoredEnchant(Enchantment.THORNS, 1, true);
                break;
            }
            case 8: {
                meta.addStoredEnchant(Enchantment.THORNS, 2, true);
                break;
            }
            case 9: {
                meta.addStoredEnchant(Enchantment.THORNS, 3, true);
                break;
            }
            case 10: {
                meta.addStoredEnchant(Enchantment.PROTECTION_PROJECTILE, 1, true);
                break;
            }
            case 11: {
                meta.addStoredEnchant(Enchantment.PROTECTION_PROJECTILE, 2, true);
                break;
            }
            case 12: {
                meta.addStoredEnchant(Enchantment.PROTECTION_PROJECTILE, 3, true);
                break;
            }
            case 13: {
                meta.addStoredEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 1, true);
                break;
            }
            case 14: {
                meta.addStoredEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 2, true);
                break;
            }
            case 15: {
                meta.addStoredEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 3, true);
                break;
            }
            case 16: {
                meta.addStoredEnchant(Enchantment.DAMAGE_ALL, 1, true);
                break;
            }
            case 17: {
                meta.addStoredEnchant(Enchantment.DAMAGE_ALL, 2, true);
                break;
            }
            case 18: {
                meta.addStoredEnchant(Enchantment.DAMAGE_ALL, 3, true);
                break;
            }
            case 19: {
                meta.addStoredEnchant(Enchantment.ARROW_DAMAGE, 1, true);
            }
        }
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public static ItemStack getEnchantedBook(int amount, EnchantLevel ... enchant) {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, amount);
        EnchantmentStorageMeta metaBook = (EnchantmentStorageMeta)book.getItemMeta();
        for (EnchantLevel e : Arrays.asList(enchant)) {
            metaBook.addStoredEnchant(e.getEnchant(), e.getLevel(), true);
        }
        book.setItemMeta((ItemMeta)metaBook);
        return book;
    }

    public static ItemStack getEnchantedBook(EnchantLevel ... enchant) {
        return ItemUtil.getEnchantedBook(1, enchant);
    }

    public static void giveEnchantedBook(Player player, int amount, EnchantLevel ... enchant) {
        InventoryUtil.addItem(player, ItemUtil.getEnchantedBook(amount, enchant));
    }

    public static boolean haveItemName(ItemStack item, String name) {
        boolean result = false;
        if (item != null && item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null && item.getItemMeta().getDisplayName().contains(name)) {
            result = true;
        }
        return result;
    }

    public static boolean isSpecialItem(ItemStack item) {
        boolean result = false;
        if (item != null && item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null && item.getItemMeta().getLore() != null) {
            result = true;
        }
        return result;
    }

    public static boolean isOre(Material mat) {
        return mat == Material.COAL_ORE || mat == Material.IRON_ORE || mat == Material.GOLD_ORE || mat == Material.DIAMOND_ORE || mat == Material.REDSTONE_ORE || mat == Material.LAPIS_ORE || mat == Material.GLOWING_REDSTONE_ORE || mat == Material.EMERALD_ORE;
    }

    public static boolean hasEnough(Player player, Material material, int value) {
        int total = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == null || item.getType() != material) continue;
            total += item.getAmount();
        }
        return total >= value;
    }

    public static String getTextItem(ItemStack item) {
        return item.getAmount() + "x" + item.getType().name();
    }

    public static String getListTextItem(List<ItemStack> items) {
        StringBuilder builder = new StringBuilder();
        items.forEach(item -> builder.append(ItemUtil.getTextItem(item)).append(", "));
        String msg = builder.toString();
        return ConfigFile.TEXT_COLOR_TEXT.getString() + (msg.length() > 1 ? msg.substring(0, msg.length() - 2) : msg);
    }

    public static boolean isDamageable(Material type) {
        if (type == null) {
            return false;
        }
        String[] split = type.toString().split("_");
        int length = split.length;
        switch (split[length - 1]) {
            case "HELMET": {
                return true;
            }
            case "CHESTPLATE": {
                return true;
            }
            case "LEGGINGS": {
                return true;
            }
            case "BOOTS": {
                return true;
            }
            case "SWORD": {
                return true;
            }
            case "AXE": {
                return true;
            }
            case "PICKAXE": {
                return true;
            }
            case "SHOVEL": {
                return true;
            }
            case "BOW": {
                return true;
            }
            case "SPADE": {
                return true;
            }
            case "HOE": {
                return true;
            }
            case "ELYTRA": {
                return true;
            }
            case "TURTLE_HELMET": {
                return true;
            }
            case "TRIDENT": {
                return true;
            }
            case "HORSE_ARMOR": {
                return true;
            }
            case "SHEARS": {
                return true;
            }
        }
        return false;
    }

    public static double getAttackDamageItem(ItemStack stack) {
        if (stack == null || stack.getType() == null || stack.getType() == Material.AIR) {
            return 1.0;
        }
        double baseDamage = 0.0;
        switch (stack.getType()) {
            case WOOD_SPADE: 
            case WOOD_HOE: 
            case GOLD_SPADE: 
            case GOLD_HOE: {
                baseDamage = 1.0;
                break;
            }
            case STONE_HOE: 
            case STONE_SPADE: 
            case WOOD_PICKAXE: 
            case GOLD_PICKAXE: {
                baseDamage = 2.0;
                break;
            }
            case STONE_PICKAXE: 
            case IRON_SPADE: 
            case IRON_HOE: 
            case WOOD_AXE: 
            case GOLD_AXE: {
                baseDamage = 3.0;
                break;
            }
            case STONE_AXE: 
            case IRON_PICKAXE: 
            case DIAMOND_SPADE: 
            case DIAMOND_HOE: 
            case WOOD_SWORD: 
            case GOLD_SWORD: {
                baseDamage = 4.0;
                break;
            }
            case IRON_AXE: 
            case DIAMOND_PICKAXE: 
            case STONE_SWORD: {
                baseDamage = 5.0;
                break;
            }
            case DIAMOND_AXE: 
            case IRON_SWORD: {
                baseDamage = 6.0;
                break;
            }
            case DIAMOND_SWORD: {
                baseDamage = 7.0;
                break;
            }
            default: {
                baseDamage = 0.0;
            }
        }
        return 1.0 + baseDamage;
    }

    public static double getEnchantEffect(Player player) {
        if (!player.hasPotionEffect(PotionEffectType.INCREASE_DAMAGE)) {
            return 0.0;
        }
        double level = 0.0;
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (effect == null || effect.getType() == null || !effect.getType().equals((Object)PotionEffectType.INCREASE_DAMAGE)) continue;
            level = 1.0 * (1.0 * (double)effect.getAmplifier() + 1.0);
            break;
        }
        return level;
    }

    public static double getEnchantDamageItem(ItemStack stack) {
        if (stack == null || stack.getType() == null || stack.getType() == Material.AIR) {
            return 0.0;
        }
        double enchantDamage = 0.0;
        if (stack.containsEnchantment(Enchantment.DAMAGE_ALL)) {
            enchantDamage = 1.25 * (double)stack.getEnchantmentLevel(Enchantment.DAMAGE_ALL);
        }
        return enchantDamage;
    }

    public static boolean isCriticalDamage(Player player) {
        return player.getFallDistance() > 0.0f && !player.isOnGround() && !player.hasPotionEffect(PotionEffectType.BLINDNESS) && player.getVehicle() == null;
    }
}

