/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.item;

import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.utils.objets.MultiBoolean;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableMultiBoolean;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public enum EnchantItem {
    PROTECTION(Enchantment.PROTECTION_ENVIRONMENTAL, "Protection", false),
    FIRE_PROTECTION(Enchantment.PROTECTION_FIRE, "Fire Protection", false),
    BLAST_PROTECTION(Enchantment.PROTECTION_EXPLOSIONS, "Blast Protection", false),
    PROJECTILE_PROTECTION(Enchantment.PROTECTION_PROJECTILE, "Projectile Protection", false),
    THORNS(Enchantment.THORNS, "Thorns", false),
    DEPTH_STRIDER(Enchantment.DEPTH_STRIDER, "Depth Strider", false),
    FEATHER_FALLING(Enchantment.PROTECTION_FALL, "Feather Falling", false),
    RESPIRATION(Enchantment.OXYGEN, "Respiration", false),
    AQUA_AFFINITY(Enchantment.WATER_WORKER, "Aqua Affinity", false),
    SHARPNESS(Enchantment.DAMAGE_ALL, "Sharpness", false),
    SMITE(Enchantment.DAMAGE_UNDEAD, "Smite", false),
    BANE_OF_ARTHROPODS(Enchantment.DAMAGE_ARTHROPODS, "Bane of Arthropods", false),
    KNOCKBACK(Enchantment.KNOCKBACK, "KnockBack", false),
    FIRE_ASPECT(Enchantment.FIRE_ASPECT, "Fire Aspect", false),
    LOOTING(Enchantment.LOOT_BONUS_MOBS, "Looting", false),
    EFFICIENCY(Enchantment.DIG_SPEED, "Efficiency", false),
    SILK_TOUCH(Enchantment.SILK_TOUCH, "Silk Touch", false),
    UNBREAKING(Enchantment.DURABILITY, "Unbreaking", false),
    FORTUNE(Enchantment.LOOT_BONUS_BLOCKS, "Fortune", false),
    POWER(Enchantment.ARROW_DAMAGE, "Power", true),
    PUNCH(Enchantment.ARROW_KNOCKBACK, "Punch", true),
    FLAME(Enchantment.ARROW_FIRE, "Flame", true),
    INFINITY(Enchantment.ARROW_INFINITE, "Infinity", true),
    LURE(Enchantment.LURE, "Lure", true),
    LUCK_OF_SEA(Enchantment.LUCK, "Luck of the Sea", true);

    private String name;
    private Enchantment enchant;
    private boolean onlyGlobal;

    private EnchantItem(Enchantment enchant, String name, boolean onlyGlobal) {
        this.enchant = enchant;
        this.name = name;
        this.onlyGlobal = onlyGlobal;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.name.toLowerCase().replace(" ", "_");
    }

    public Enchantment getEnchant() {
        return this.enchant;
    }

    public boolean isOnlyGlobal() {
        return this.onlyGlobal;
    }

    public int getMaxLevel() {
        return this.enchant.getMaxLevel();
    }

    public void addSettings() {
        new Settings(ValueCategorie.GLOBAL_ENCHANT, (Variable)new VariableMultiBoolean("enchantments.global." + this.getKey(), new ItemStack(Material.ENCHANTED_BOOK), new MultiBoolean(this.enchant.getMaxLevel(), this.enchant.getMaxLevel() + 1)));
        if (!this.isOnlyGlobal()) {
            new Settings(ValueCategorie.DIAMOND_ENCHANT, (Variable)new VariableMultiBoolean("enchantments.diamond." + this.getKey(), new ItemStack(Material.ENCHANTED_BOOK), new MultiBoolean(this.enchant.getMaxLevel(), this.enchant.getMaxLevel() + 1)));
            new Settings(ValueCategorie.IRON_ENCHANT, (Variable)new VariableMultiBoolean("enchantments.iron." + this.getKey(), new ItemStack(Material.ENCHANTED_BOOK), new MultiBoolean(this.enchant.getMaxLevel(), this.enchant.getMaxLevel() + 1)));
        }
    }

    public Settings getGlobalSettings() {
        return SettingsManager.getSettings("enchantments.global." + this.getKey());
    }

    public int getGlobalValue() {
        return (Integer)this.getGlobalSettings().getValue();
    }

    public Settings getDiamondSettings() {
        return SettingsManager.getSettings("enchantments.diamond." + this.getKey());
    }

    public int getDiamondValue() {
        if (this.onlyGlobal) {
            return this.getGlobalValue();
        }
        return (Integer)this.getDiamondSettings().getValue();
    }

    public Settings getIronSettings() {
        return SettingsManager.getSettings("enchantments.iron." + this.getKey());
    }

    public int getIronValue() {
        if (this.onlyGlobal) {
            return this.getGlobalValue();
        }
        return (Integer)this.getIronSettings().getValue();
    }

    public static EnchantItem getEnchant(Enchantment enchant) {
        for (EnchantItem item : EnchantItem.values()) {
            if (!enchant.equals((Object)item.getEnchant())) continue;
            return item;
        }
        return null;
    }
}

