/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.chat.color;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.util.chat.color.Colors;
import eu.scorpionltd.uhc.util.chat.color.Symbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Prefix {
    private static final Colors[] colors = new Colors[]{Colors.BLUE, Colors.RED, Colors.GREEN, Colors.YELLOW, Colors.AQUA, Colors.PINK, Colors.ORANGE, Colors.GRAY, Colors.PURPLE};
    private static final Symbols[] symbols = new Symbols[]{Symbols.NONE, Symbols.HEARTH, Symbols.SPADE, Symbols.SUN, Symbols.DEATH, Symbols.STAR, Symbols.CROSS, Symbols.SQUARE, Symbols.LOZENGE};
    private final Colors color;
    private final Symbols symbol;
    private String prefix;

    public Prefix(String prefix) {
        this.prefix = prefix;
        this.color = null;
        this.symbol = null;
    }

    public Prefix(Colors color, Symbols symbol) {
        this.color = color;
        this.symbol = symbol;
        this.prefix = "";
    }

    public String getPrefixName() {
        if (this.prefix != "") {
            return this.prefix;
        }
        return this.color.getText() + this.symbol.getPrefix();
    }

    public String getTextName() {
        if (this.prefix != "") {
            return this.prefix;
        }
        return this.getPrefixName() + this.color.getName();
    }

    public Colors getColor() {
        return this.color;
    }

    public Symbols getSymbol() {
        return this.symbol;
    }

    public ItemStack getBanner() {
        ItemStack banner = new ItemStack(Material.BANNER, 1);
        BannerMeta m = (BannerMeta)banner.getItemMeta();
        if (this.symbol == Symbols.STAR) {
            m.setBaseColor(DyeColor.BLACK);
        } else {
            m.setBaseColor(this.color.getSheep());
        }
        m.setPatterns(this.symbol.getColoredPatterns(this.color));
        banner.setItemMeta((ItemMeta)m);
        return banner;
    }

    public ItemStack getBannerColor() {
        ItemStack banner = new ItemStack(Material.BANNER, 1);
        BannerMeta m = (BannerMeta)banner.getItemMeta();
        m.setBaseColor(this.color.getSheep());
        banner.setItemMeta((ItemMeta)m);
        return banner;
    }

    public ItemStack getMelangedBannerColor(int numberColors) {
        ItemStack banner = new ItemStack(Material.BANNER, 1);
        BannerMeta m = (BannerMeta)banner.getItemMeta();
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>();
        colors.add(this.color.getSheep());
        for (int i = 0; i < numberColors - 1; ++i) {
            Colors randomColor = Colors.getRandomColor();
            while (colors.contains(randomColor.getSheep())) {
                randomColor = Colors.getRandomColor();
            }
            colors.add(randomColor.getSheep());
        }
        ArrayList<PatternType> patterns = new ArrayList<PatternType>();
        patterns.add(PatternType.HALF_VERTICAL);
        patterns.add(PatternType.SQUARE_TOP_LEFT);
        patterns.add(PatternType.SQUARE_TOP_RIGHT);
        patterns.add(PatternType.SQUARE_BOTTOM_LEFT);
        patterns.add(PatternType.SQUARE_BOTTOM_RIGHT);
        Collections.shuffle(colors);
        m.setBaseColor((DyeColor)colors.remove(0));
        for (DyeColor color : colors) {
            m.addPattern(new Pattern(color, (PatternType)patterns.remove(0)));
        }
        banner.setItemMeta((ItemMeta)m);
        return banner;
    }

    public ItemStack getFirework() {
        ItemStack firework = new ItemStack(Material.FIREWORK, 64);
        FireworkMeta m = (FireworkMeta)firework.getItemMeta();
        m.addEffect(FireworkEffect.builder().with(this.symbol.getType()).withColor(this.color.getColor()).build());
        m.setPower(2);
        firework.setItemMeta((ItemMeta)m);
        return firework;
    }

    public static List<Prefix> getAllPrefix() {
        ArrayList<Prefix> prefixs = new ArrayList<Prefix>();
        for (Symbols symbol : symbols) {
            for (Colors color : colors) {
                prefixs.add(new Prefix(color, symbol));
            }
        }
        return prefixs;
    }

    public static Prefix getNextPrefix() {
        for (Symbols symbol : symbols) {
            for (Colors color : colors) {
                boolean exists = false;
                for (UHCTeam team : UHC.getTeamManager().getTeams()) {
                    if (!team.getPrefix().color.equals((Object)color) || !team.getPrefix().symbol.equals((Object)symbol)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                return new Prefix(color, symbol);
            }
        }
        return new Prefix(Colors.DARK_GRAY, Symbols.NONE);
    }

    public static Prefix getRandom() {
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            Colors color = colors[random.nextInt(colors.length)];
            Symbols symbol = symbols[random.nextInt(symbols.length)];
            boolean exists = false;
            for (UHCTeam team : UHC.getTeamManager().getTeams()) {
                if (!team.getPrefix().color.equals((Object)color) || !team.getPrefix().symbol.equals((Object)symbol)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return new Prefix(color, symbol);
        }
        return new Prefix(Colors.DARK_GRAY, Symbols.NONE);
    }
}

