/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util.chat;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.integration.OpenTime;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.tasks.Timer;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.tasks.runnable.GameTimer;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.monde.ArenaUtil;
import eu.scorpionltd.utils.DateUtils;
import eu.scorpionltd.utils.objets.SymbolBank;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ChatUtil {
    private static boolean muteChat = false;
    private static int groupes = 5;

    public static boolean isMuteChat() {
        return muteChat;
    }

    public static void inverseMuteChat() {
        muteChat = !muteChat;
    }

    public static int getGroupes() {
        return groupes;
    }

    public static void changeGroupes(int valeur) {
        groupes = valeur;
    }

    public static String getArrow() {
        return ChatColor.DARK_GRAY + "\u00bb ";
    }

    public static String getLine() {
        return ChatColor.DARK_GRAY + "" + ChatColor.STRIKETHROUGH + "------------";
    }

    public static String getVersionType() {
        return ChatColor.RED + "" + ChatColor.BOLD + (UHC.getInstance().isPRO() ? "PRO" : "LITE");
    }

    public static String getMainPrefix() {
        return ConfigFile.TEXT_MAIN_PREFIX.getString().replace("&", "\u00a7");
    }

    public static String getConfigPrefix() {
        return ConfigFile.TEXT_CONFIG_PREFIX.getString().replace("&", "\u00a7");
    }

    public static String getAdminPrefix() {
        return ConfigFile.TEXT_ADMIN_PREFIX.getString().replace("&", "\u00a7");
    }

    public static String getHostPrefix() {
        return ConfigFile.TEXT_HOST_PREFIX.getString().replace("&", "\u00a7");
    }

    public static String getTeamPrefix() {
        return ConfigFile.TEXT_TEAM_PREFIX.getString().replace("&", "\u00a7");
    }

    public static int getNumberGames() {
        return ConfigFile.PUBLIC_GAMES.getInteger() + (Status.getCurrentStatus().isStart() ? 0 : 1);
    }

    public static void sendConfigAll(String msg) {
        Bukkit.broadcastMessage((String)(ChatUtil.getConfigPrefix() + msg));
    }

    public static void sendAlert(TextComponent component) {
        UHCPlayerManager.getStaffwith(Permissions.ALERTS).forEach(up -> up.getPlayer().spigot().sendMessage((BaseComponent)component));
    }

    public static TextComponent getCompleteAlert(String part1, String part2, String hoverText, Location loc) {
        TextComponent message = new TextComponent(ChatColor.DARK_RED + "" + ChatColor.BOLD + "[!] " + ChatColor.GREEN + part1 + ChatColor.DARK_GREEN + " \u00bb " + ChatColor.AQUA + part2);
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverText).create()));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tploc " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ() + " " + loc.getWorld().getName()));
        return message;
    }

    public static TextComponent getAlert(String alertType, String player, Location loc) {
        return ChatUtil.getCompleteAlert(alertType, player, "Teleport to", loc);
    }

    public static TextComponent getDeathAlert(String alertType, String player, Location loc) {
        TextComponent message = new TextComponent(ChatColor.GOLD + "" + ChatColor.BOLD + "[" + SymbolBank.DEATH + "] " + ChatColor.GREEN + alertType + ChatColor.DARK_GREEN + " \u00bb " + ChatColor.AQUA + player);
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Teleport to").create()));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tploc " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ() + " " + loc.getWorld().getName()));
        return message;
    }

    public static TextComponent getHelpop(String player, String text, Location loc) {
        TextComponent message = new TextComponent(ChatColor.DARK_AQUA + "" + ChatColor.BOLD + "[?] " + ChatColor.AQUA + player + ChatColor.DARK_GREEN + " \u00bb " + ChatColor.WHITE + text);
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Teleport to").create()));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tploc " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ() + " " + loc.getWorld().getName()));
        return message;
    }

    public static String convertText(String text) {
        String scenarios;
        StringBuilder build;
        UHCPlayer host;
        String final_message = text;
        if (final_message.contains("&")) {
            final_message = final_message.replace("&", "\u00a7");
        }
        if (final_message.contains("(time)")) {
            final_message = final_message.replace("(time)", "");
        }
        if (!final_message.contains("<") || !final_message.contains(">")) {
            return final_message;
        }
        if (final_message.contains("<prefix>")) {
            final_message = final_message.replace("<prefix>", ChatUtil.getMainPrefix());
        }
        if (final_message.contains("<config_prefix>")) {
            final_message = final_message.replace("<config_prefix>", ChatUtil.getConfigPrefix());
        }
        if (final_message.contains("<admin_prefix>")) {
            final_message = final_message.replace("<admin_prefix>", ChatUtil.getAdminPrefix());
        }
        if (final_message.contains("<host_prefix>")) {
            final_message = final_message.replace("<host_prefix>", ChatUtil.getHostPrefix());
        }
        if (final_message.contains("<team_prefix>")) {
            final_message = final_message.replace("<team_prefix>", ChatUtil.getTeamPrefix());
        }
        if (final_message.contains("<arrow>")) {
            final_message = final_message.replace("<arrow>", ChatUtil.getArrow());
        }
        if (final_message.contains("<ligne>")) {
            final_message = final_message.replace("<ligne>", ChatUtil.getLine());
        }
        if (final_message.contains("<number_games>")) {
            final_message = final_message.replace("<number_games>", ChatUtil.getNumberGames() + "");
        }
        if (final_message.contains("<host_name>")) {
            host = UHCPlayerManager.getActualHost();
            final_message = final_message.replace("<host_name>", host == null ? ChatColor.RED + "Unknown" : host.getName());
        }
        if (final_message.contains("<host_twitter>")) {
            host = UHCPlayerManager.getActualHost();
            final_message = final_message.replace("<host_twitter>", host == null ? ChatColor.RED + "Unknown" : host.getInfos().getTwitterName());
        }
        if (final_message.contains("<host_number>")) {
            host = UHCPlayerManager.getActualHost();
            final_message = final_message.replace("<host_number>", "" + (host == null ? 0 : host.getInfos().getGlobalHostGames()));
        }
        if (final_message.contains("<scenarios>")) {
            build = new StringBuilder();
            build.append("");
            for (Scenario scenario : ScenarioManager.getActivatedScenarios()) {
                build.append(scenario.getName() + ", ");
            }
            scenarios = build.toString();
            final_message = final_message.replace("<scenarios>", scenarios == "" || scenarios.length() < 2 ? ChatColor.RED + "Unknown" : scenarios.substring(0, scenarios.length() - 2));
        }
        if (final_message.contains("<normal_scenarios>")) {
            build = new StringBuilder();
            build.append("");
            for (Scenario scenario : ScenarioManager.getActivatedNormalScenario()) {
                build.append(scenario.getName() + ", ");
            }
            scenarios = build.toString();
            final_message = final_message.replace("<normal_scenarios>", scenarios == "" || scenarios.length() < 2 ? ChatColor.RED + "Unknown" : scenarios.substring(0, scenarios.length() - 2));
        }
        if (final_message.contains("<gamemodes>")) {
            build = new StringBuilder();
            build.append("");
            for (Scenario scenario : ScenarioManager.getActivatedGamemodes()) {
                build.append(scenario.getName() + ", ");
            }
            scenarios = build.toString();
            final_message = final_message.replace("<gamemodes>", scenarios == "" || scenarios.length() < 2 ? ChatColor.RED + "Unknown" : scenarios.substring(0, scenarios.length() - 2));
        }
        if (final_message.contains("<tps>")) {
            final_message = final_message.replace("<tps>", ServerUtil.getTPS());
        }
        if (final_message.contains("<format_tps>")) {
            final_message = final_message.replace("<format_tps>", ServerUtil.getFormattedTPS());
        }
        if (final_message.contains("<utc>")) {
            final_message = final_message.replace("<utc>", ServerUtil.getTimeUTC());
        }
        if (final_message.contains("<utc:") && final_message.contains(">")) {
            for (int i = -12; i <= 12; ++i) {
                if (!final_message.contains("<utc:" + i + ">")) continue;
                final_message = final_message.replace("<utc:" + i + ">", ServerUtil.getTimeUTC(i));
            }
        }
        if (final_message.contains("<number_players>")) {
            final_message = final_message.replace("<number_players>", UHCPlayerManager.getPlayersConnectedNumber() + "");
        }
        if (final_message.contains("<max_players>")) {
            final_message = final_message.replace("<max_players>", Values.SERVER_SLOTS.getInteger() + "");
        }
        if (final_message.contains("<teamsize>")) {
            final_message = final_message.replace("<teamsize>", UHC.getTeamManager().getTeamName());
        }
        if (final_message.contains("<game_timer>")) {
            final_message = final_message.replace("<game_timer>", DateUtils.ticksToString((long)GameTimer.getTime()));
        }
        if (final_message.contains("<episode_timer>")) {
            final_message = final_message.replace("<episode_timer>", DateUtils.ticksToString((long)GameTimer.getEpisodeTime()));
        }
        for (Timer timer : TimerManager.getTimers()) {
            if (!final_message.contains("<" + timer.getKey() + ">")) continue;
            if (timer.isActive()) {
                final_message = final_message.replace("<" + timer.getKey() + ">", timer.getDisplayTime());
                continue;
            }
            final_message = final_message.replace("<" + timer.getKey() + ">", timer.getDisplayActive());
        }
        if (final_message.contains("<border>")) {
            int size = (int)ArenaUtil.getArenaWorld().getWorldBorder().getSize();
            int n = size > 10000 ? Values.BORDER_SIZE_INIT.getInteger() : size / 2;
            final_message = final_message.replace("<border>", n + "");
        }
        if (final_message.contains("<time_open>")) {
            final_message = final_message.replace("<time_open>", OpenTime.getInstance() == null ? "XX:YY" : ChatColor.stripColor((String)OpenTime.getInstance().getText()));
        }
        if (final_message.contains("<groupes>")) {
            final_message = final_message.replace("<groupes>", "" + ChatUtil.getGroupes());
        }
        while (final_message.contains("<code:") && final_message.contains(">")) {
            String code = final_message.split("<code:")[1].split(">")[0];
            char c = (char)Integer.parseInt(code, 16);
            final_message = final_message.replace("<code:" + code + ">", "" + c);
        }
        if (final_message.contains("<retour>")) {
            final_message = final_message.replace("<retour>", "\n");
        }
        if (final_message.contains("<full_square>")) {
            final_message = final_message.replace("<full_square>", "\u25a0");
        }
        if (final_message.contains("<cross>")) {
            final_message = final_message.replace("<cross>", "\u2716");
        }
        if (final_message.contains("<plus_minus>")) {
            final_message = final_message.replace("<plus_minus>", "\u00b1");
        }
        if (final_message.contains("<simple_arrow>")) {
            final_message = final_message.replace("<simple_arrow>", "\u00bb");
        }
        if (final_message.contains("<e1>")) {
            final_message = final_message.replace("<e1>", "\u00e9");
        }
        if (final_message.contains("<e2>")) {
            final_message = final_message.replace("<e2>", "\u00e8");
        }
        if (final_message.contains("<e3>")) {
            final_message = final_message.replace("<e3>", "\u00ea");
        }
        if (final_message.contains("<e4>")) {
            final_message = final_message.replace("<e4>", "\u00eb");
        }
        if (final_message.contains("<E1>")) {
            final_message = final_message.replace("<E1>", "\u00c9");
        }
        if (final_message.contains("<a1>")) {
            final_message = final_message.replace("<a1>", "\u00e0");
        }
        if (final_message.contains("<a2>")) {
            final_message = final_message.replace("<a2>", "\u00e2");
        }
        if (final_message.contains("<o1>")) {
            final_message = final_message.replace("<o1>", "\u00f4");
        }
        if (final_message.contains("<i1>")) {
            final_message = final_message.replace("<i1>", "\u00ee");
        }
        if (final_message.contains("<i2>")) {
            final_message = final_message.replace("<i2>", "\u00ef");
        }
        if (final_message.contains("<u1>")) {
            final_message = final_message.replace("<u1>", "\u00f9");
        }
        if (final_message.contains("<u2>")) {
            final_message = final_message.replace("<u2>", "\u00b5");
        }
        if (final_message.contains("<c1>")) {
            final_message = final_message.replace("<c1>", "\u00e7");
        }
        if (final_message.contains("<s1>")) {
            final_message = final_message.replace("<s1>", "'");
        }
        return final_message;
    }

    public static String getTime(ScorpionPlayer sp, Integer mt) {
        return ChatUtil.getTime(UHCPlayerManager.getPlayer(sp).getLangue(), mt);
    }

    public static String getTime(Player p, Integer mt) {
        return ChatUtil.getTime(UHCPlayerManager.getPlayer(p).getLangue(), mt);
    }

    public static String getTime(Langue langue, Integer mt) {
        String time = new String();
        String color_number = ConfigFile.TEXT_COLOR_NUMBER.getString();
        String color_text = ConfigFile.TEXT_COLOR_TEXT.getString();
        long seconds = mt % 60;
        long minutes = mt / 60 % 60;
        long hours = mt / 60 / 60 % 24;
        long days = mt / 60 / 60 / 24 % 365;
        long years = mt / 60 / 60 / 24 / 365;
        if (years > 0L) {
            String string = time = years < 2L ? time + " " + color_number + years + color_text + " " + MEnum.TIME_YEAR.getText(langue, new Object[0]) : time + " " + color_number + years + color_text + " " + MEnum.TIME_MULTIPLE_YEAR.getText(langue, new Object[0]);
        }
        if (days > 0L) {
            String string = time = days < 2L ? time + " " + color_number + days + color_text + " " + MEnum.TIME_DAY.getText(langue, new Object[0]) : time + " " + color_number + days + color_text + " " + MEnum.TIME_MULTIPLE_DAY.getText(langue, new Object[0]);
        }
        if (hours > 0L && years <= 0L) {
            String string = time = hours < 2L ? time + " " + color_number + hours + color_text + " " + MEnum.TIME_HOUR.getText(langue, new Object[0]) : time + " " + color_number + hours + color_text + " " + MEnum.TIME_MULTIPLE_HOUR.getText(langue, new Object[0]);
        }
        if (minutes > 0L && days <= 0L) {
            String string = time = minutes < 2L ? time + " " + color_number + minutes + color_text + " " + MEnum.TIME_MINUTE.getText(langue, new Object[0]) : time + " " + color_number + minutes + color_text + " " + MEnum.TIME_MULTIPLE_MINUTE.getText(langue, new Object[0]);
        }
        if (seconds > 0L && hours <= 0L) {
            String string = time = seconds < 2L ? time + " " + color_number + seconds + color_text + " " + MEnum.TIME_SECOND.getText(langue, new Object[0]) : time + " " + color_number + seconds + color_text + " " + MEnum.TIME_MULTIPLE_SECOND.getText(langue, new Object[0]);
        }
        if (time.isEmpty()) {
            time = time + " " + color_number + seconds + color_text + " " + MEnum.TIME_SECOND.getText(langue, new Object[0]);
        }
        return time.substring(1);
    }

    public static String getNumberWithText(Langue langue, int i, UHCMessage msg) {
        if (msg == null || msg.getBrut(langue) == null) {
            return ChatColor.RED + "" + i;
        }
        if (msg.getBrut(langue).contains("(time)")) {
            return ChatUtil.getTime(langue, (Integer)i);
        }
        return ConfigFile.TEXT_COLOR_NUMBER.getString() + i + " " + ConfigFile.TEXT_COLOR_TEXT.getString() + msg.getText(langue, new Object[0]);
    }

    public static String getPlayerList(List<UHCPlayer> players) {
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (UHCPlayer player : players) {
            if (sb.length() > 0) {
                if (players.size() == i) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(player.getName());
            ++i;
        }
        return sb.toString();
    }

    public static String getBukkitPlayerList(List<Player> players) {
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (Player player : players) {
            if (sb.length() > 0) {
                if (players.size() == i) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(player.getName());
            ++i;
        }
        return sb.toString();
    }

    public static String getOfflinePlayerList(Set<OfflinePlayer> players) {
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (OfflinePlayer player : players) {
            if (sb.length() > 0) {
                if (players.size() == i) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(player.getName());
            ++i;
        }
        return sb.toString();
    }

    public static String getUUIDPlayerList(List<UUID> players) {
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (UUID uuid : players) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (sb.length() > 0) {
                if (players.size() == i) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(player.getName());
            ++i;
        }
        return sb.toString();
    }

    public static String convertTimeToDate(String pattern, Long mt) {
        Date date = new Date(mt);
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String getBarPercent(double maxProgress, double currentProgress, int numberBar) {
        double progressPercent = currentProgress / maxProgress;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberBar; ++i) {
            if ((double)i < (double)numberBar * progressPercent) {
                sb.append(ChatColor.GREEN + "|");
                continue;
            }
            sb.append(ChatColor.RED + "|");
        }
        return sb.toString();
    }
}

