/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.util;

import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.utils.objets.SymbolBank;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class MethsUtil {
    public static void giveExplosion(Player player, float damage) {
        Metadata.FIRST_EXPLOSION.add(player);
        player.getWorld().createExplosion(player.getLocation(), damage);
    }

    public static void givePotion(Player player, int amount, PotionType type, int level, boolean isSplash, boolean isExtended) {
        Potion potion = new Potion(type, level);
        potion.setSplash(isSplash);
        potion.setHasExtendedDuration(isExtended);
        player.getInventory().addItem(new ItemStack[]{potion.toItemStack(amount)});
        player.updateInventory();
    }

    public static void senderCenterPosition(Player p) {
        Location loc = p.getLocation();
        double distance = loc.distance(new Location(p.getWorld(), (double)Values.BORDER_CENTER_X.getInteger(), loc.getY(), (double)Values.BORDER_CENTER_Z.getInteger()));
        String msg = ChatColor.DARK_RED + SymbolBank.ARROW + " + 800 blocks";
        if (distance < 800.0 && distance >= 600.0) {
            msg = ChatColor.RED + SymbolBank.ARROW + " + 600-800 blocks";
        } else if (distance < 600.0 && distance >= 400.0) {
            msg = ChatColor.GOLD + SymbolBank.ARROW + " + 400-600 blocks";
        } else if (distance < 400.0 && distance >= 200.0) {
            msg = ChatColor.YELLOW + SymbolBank.ARROW + " + 200-400 blocks";
        } else if (distance < 200.0) {
            msg = ChatColor.GREEN + SymbolBank.ARROW + " + 0-200 blocks";
        }
        ScorpionPlayer.getScorpionPlayer((Player)p).getPlayerPacket().sendActionBar(msg + ChatColor.DARK_GRAY + " | " + ChatColor.DARK_AQUA + "Y = " + loc.getBlockY());
    }

    public static String getFacing(Player player) {
        float yaw = player.getLocation().getYaw();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return "South";
        }
        if (yaw < 135.0f) {
            return "West";
        }
        if (yaw < 225.0f) {
            return "North";
        }
        if (yaw < 315.0f) {
            return "East";
        }
        return "North";
    }

    public static ItemStack getSplashPotion(int amount, PotionType type, int level) {
        Potion potion = new Potion(type, level);
        potion.setSplash(true);
        return potion.toItemStack(amount);
    }

    public static void giveSplashPotion(Player player, int amount, PotionType type, int level) {
        InventoryUtil.addItem(player, MethsUtil.getSplashPotion(amount, type, level));
    }
}

