/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.player.profile;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.ui.player.profile.MenuPlayer;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;

public class MenuStats
extends CustomInventory {
    private UHCPlayer playerStat;
    private boolean profileStat;

    public MenuStats(ScorpionPlayer sp, UHCPlayer playerStat, boolean profileStat) {
        super(sp, MEnum.MENU_PLAYER_STATS.getText(sp, playerStat.getName()), 1, 1);
        this.playerStat = playerStat;
        this.profileStat = profileStat;
    }

    public void setupMenu() {
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_TEAM.getColor(), " ").toItemStack(), 1);
        PlayerInfos infos = this.playerStat.getInfos();
        if (this.profileStat) {
            this.addReturnItem(0, new MenuPlayer(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        } else {
            Item profil = new Item(Material.SKULL_ITEM, 3, ChatColor.AQUA + this.playerStat.getName());
            this.addItem(new StaticItem(0, profil.toItemStackwithSkull(this.playerStat.getName())));
        }
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        boolean haveHostGame = infos.getGlobalHostGames() > 0;
        boolean haveSpecTime = infos.getGlobalSpecTime() > 0;
        ArrayList<String> winsLore = new ArrayList<String>();
        winsLore.add("");
        winsLore.add(this.getStatLine("Played Games", infos.getGlobalGames() + "", ""));
        winsLore.add(this.getStatLine("Wins", infos.getGlobalWins() + "", ""));
        if (haveHostGame || haveSpecTime) {
            winsLore.add("");
            if (haveHostGame) {
                winsLore.add(this.getStatLine("Hosted Games", infos.getGlobalHostGames() + "", ""));
            }
            if (haveSpecTime) {
                winsLore.add(this.getStatLine("Spec Time", ChatUtil.getTime(this.player, (Integer)infos.getGlobalSpecTime()), ""));
            }
        }
        Item wins = new Item(Material.DIAMOND, this.getStatLine("Win Rate", infos.getWinRatioText(), ""));
        wins.setLore(winsLore);
        this.addItem(new StaticItem(2, wins.toItemStack()));
        Item kills = new Item(Material.IRON_SWORD, this.getStatLine("K/D Ratio", infos.getKillRatioText(), ""));
        kills.setLore(new String[]{"", this.getStatLine("Kills", infos.getGlobalKills() + "", ""), this.getStatLine("Deaths", infos.getGlobalDeaths() + "", ""), "", this.getStatLine("Best KillStreak", infos.getGlobalBestKillstreak() + "", "")});
        this.addItem(new StaticItem(3, kills.toItemStackwithItemFlag(ItemFlag.values())));
        Item mining = new Item(Material.GOLD_PICKAXE, this.getStatLine("Cave Time", ChatUtil.getTime(this.player, (Integer)infos.getGlobalCaveTime()), ""));
        mining.setLore(new String[]{"", this.getStatLine("Mining Diamonds", infos.getGlobalDiamonds() + "", ""), this.getStatLine("Mining Golds", infos.getGlobalGolds() + "", ""), this.getStatLine("Mining Irons", infos.getGlobalIrons() + "", "")});
        this.addItem(new StaticItem(4, mining.toItemStackwithItemFlag(ItemFlag.values())));
        Item monsters = new Item(Material.ROTTEN_FLESH, this.getStatLine("Killed Monsters", infos.getGlobalMonsters() + "", ""));
        monsters.setLore(new String[]{"", this.getStatLine("Killed Animals", infos.getGlobalAnimals() + "", "")});
        this.addItem(new StaticItem(5, monsters.toItemStack()));
        Item longshot = new Item(Material.BOW, this.getStatLine("Best Longshot", MathUtil.convertDouble(infos.getGlobalBestLongshot()) + "", "blocks"));
        this.addItem(new StaticItem(6, longshot.toItemStack()));
    }

    private String getStatLine(String name, String value, String valueType) {
        String valueTypeText = valueType == "" ? "" : ChatColor.GRAY + " " + valueType;
        return ChatColor.YELLOW + name + " " + ChatUtil.getArrow() + ChatColor.AQUA + value + valueTypeText;
    }
}

