/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.host.players;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.infos.PlayerModifiers;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.ui.host.players.MenuPlayers;
import eu.scorpionltd.uhc.util.item.EnchantItem;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuPlayersConfig
extends CustomInventory {
    private UHCPlayer target;

    public MenuPlayersConfig(ScorpionPlayer player, UHCPlayer target) {
        super(player, MEnum.MENU_HOST_PLAYERS_CONFIG.getText(player, new Object[0]), 3, 1);
        this.target = target;
    }

    public void setupMenu() {
        this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_HOST.getColor(), " ").toItemStack());
        final PlayerModifiers modifiers = this.target.getModifiers();
        Item naturalRegeneration = new Item(Material.GOLDEN_APPLE, Values.NATURAL_REGENERATION.getSettings().getName(this.player));
        if (modifiers.getNaturelRegeneration() == -1) {
            naturalRegeneration.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + MEnum.NOT_DEFINE.getText(this.player, new Object[0])});
        } else {
            naturalRegeneration.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + (modifiers.getNaturelRegeneration() == 0 ? MEnum.VALUE_OFF.getText(this.player, new Object[0]) : MEnum.VALUE_ON.getText(this.player, new Object[0]))});
        }
        this.addActionItem(new ActionItem(3, naturalRegeneration.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                modifiers.switchNaturelRegeneration();
                MenuPlayersConfig.this.openMenu();
            }
        });
        Item diamondArmor = new Item(Material.DIAMOND, Values.ITEM_ARMOR_LIMIT.getSettings().getName(this.player));
        if (modifiers.getDiamondArmorLimit() == -1) {
            diamondArmor.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + MEnum.NOT_DEFINE.getText(this.player, new Object[0])});
        } else {
            diamondArmor.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + UHCMessage.get(Values.ITEM_ARMOR_LIMIT.getSettings().getPath() + "." + modifiers.getDiamondArmorLimit()).getText(this.player, new Object[0])});
        }
        this.addActionItem(new ActionItem(5, diamondArmor.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                modifiers.switchDiamondArmorLimit();
                MenuPlayersConfig.this.openMenu();
            }
        });
        this.addReturnItem(9, new MenuPlayers(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        this.addCloseItem(17, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        Item diamondSword = new Item(Material.DIAMOND_SWORD, EnchantItem.SHARPNESS.getDiamondSettings().getName(this.player));
        if (modifiers.getSharpnessDiamond() == -1) {
            diamondSword.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + MEnum.NOT_DEFINE.getText(this.player, new Object[0])});
        } else {
            diamondSword.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + UHCMessage.get(EnchantItem.SHARPNESS.getDiamondSettings().getPath() + "." + modifiers.getSharpnessDiamond()).getText(this.player, new Object[0])});
        }
        this.addActionItem(new ActionItem(18, diamondSword.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                modifiers.switchSharpnessDiamond();
                MenuPlayersConfig.this.openMenu();
            }
        });
        Item ironSword = new Item(Material.IRON_SWORD, EnchantItem.SHARPNESS.getIronSettings().getName(this.player));
        if (modifiers.getSharpnessIron() == -1) {
            ironSword.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + MEnum.NOT_DEFINE.getText(this.player, new Object[0])});
        } else {
            ironSword.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + UHCMessage.get(EnchantItem.SHARPNESS.getIronSettings().getPath() + "." + modifiers.getSharpnessIron()).getText(this.player, new Object[0])});
        }
        this.addActionItem(new ActionItem(20, ironSword.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                modifiers.switchSharpnessIron();
                MenuPlayersConfig.this.openMenu();
            }
        });
        Item diamondPickaxe = new Item(Material.DIAMOND_PICKAXE, MEnum.INGAME_GIVE_DIAMOND_PICKAXE_NAME.getText(this.player, new Object[0]));
        diamondPickaxe.addEnchantement(Enchantment.DIG_SPEED, 4);
        diamondPickaxe.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + (modifiers.getGiveDiamondPickaxe() == 0 ? MEnum.VALUE_OFF.getText(this.player, new Object[0]) : MEnum.VALUE_ON.getText(this.player, new Object[0]))});
        this.addActionItem(new ActionItem(22, diamondPickaxe.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                modifiers.switchGiveDiamondPickaxe();
                MenuPlayersConfig.this.openMenu();
            }
        });
        Item ironProtection = new Item(Material.IRON_CHESTPLATE, EnchantItem.PROTECTION.getIronSettings().getName(this.player));
        if (modifiers.getProtectionIron() == -1) {
            ironProtection.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + MEnum.NOT_DEFINE.getText(this.player, new Object[0])});
        } else {
            ironProtection.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + UHCMessage.get(EnchantItem.PROTECTION.getIronSettings().getPath() + "." + modifiers.getProtectionIron()).getText(this.player, new Object[0])});
        }
        this.addActionItem(new ActionItem(24, ironProtection.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                modifiers.switchProtectionIron();
                MenuPlayersConfig.this.openMenu();
            }
        });
        Item diamondProtection = new Item(Material.DIAMOND_CHESTPLATE, EnchantItem.PROTECTION.getDiamondSettings().getName(this.player));
        if (modifiers.getProtectionDiamond() == -1) {
            diamondProtection.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + MEnum.NOT_DEFINE.getText(this.player, new Object[0])});
        } else {
            diamondProtection.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0]), " ", MEnum.STATE.getText(this.player, new Object[0]) + UHCMessage.get(EnchantItem.PROTECTION.getDiamondSettings().getPath() + "." + modifiers.getProtectionDiamond()).getText(this.player, new Object[0])});
        }
        this.addActionItem(new ActionItem(26, diamondProtection.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                modifiers.switchProtectionDiamond();
                MenuPlayersConfig.this.openMenu();
            }
        });
    }
}

