/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.host.game;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.ui.host.game.MenuPlayerInventory;
import eu.scorpionltd.uhc.ui.player.infos.MenuGameFullBackpack;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuProfile
extends CustomInventory {
    private UHCPlayer playerStat;

    public MenuProfile(ScorpionPlayer sp, UHCPlayer playerStat) {
        super(sp, MEnum.MENU_PLAYER_PROFIL.getText(sp, playerStat.getName()), 3, 1);
        this.playerStat = playerStat;
    }

    public void setupMenu() {
        this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_TEAM.getColor(), " ").toItemStack());
        PlayerInfos infos = this.playerStat.getInfos();
        Item profil = new Item(Material.SKULL_ITEM, 3, ChatColor.AQUA + this.playerStat.getName());
        profil.setLore(new String[]{"", ChatColor.GRAY + "In Game " + ChatUtil.getArrow() + (this.playerStat.isPlaying() ? ChatColor.GREEN + "Yes" : ChatColor.RED + "No"), ChatColor.GRAY + "Online " + ChatUtil.getArrow() + (!this.playerStat.isDeconnecting() ? ChatColor.GREEN + "Yes" : ChatColor.RED + "No")});
        this.addItem(new StaticItem(4, profil.toItemStackwithSkull(this.playerStat.getName())));
        this.addCloseItem(9, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        this.addCloseItem(17, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        Item kills = new Item(Material.IRON_SWORD, this.getStatLine("Kills", infos.getCurrentKills() + "", ""));
        this.addItem(new StaticItem(11, kills.toItemStack()));
        Item mining = new Item(Material.GOLD_PICKAXE, this.getStatLine("Cave Time", ChatUtil.getTime(this.player, (Integer)infos.getCurrentCaveTime()), ""));
        mining.setLore(new String[]{"", this.getStatLine("Mining Diamonds", infos.getCurrentDiamonds() + "", ""), this.getStatLine("Mining Golds", infos.getCurrentGolds() + "", ""), this.getStatLine("Mining Irons", infos.getCurrentIrons() + "", "")});
        this.addItem(new StaticItem(12, mining.toItemStack()));
        Item monsters = new Item(Material.ROTTEN_FLESH, this.getStatLine("Killed Monsters", infos.getCurrentMonsters() + "", ""));
        monsters.setLore(new String[]{"", this.getStatLine("Killed Animals", infos.getCurrentAnimals() + "", "")});
        this.addItem(new StaticItem(13, monsters.toItemStack()));
        Item playerInv = new Item(Material.CHEST, ChatColor.YELLOW + "See player inventory");
        this.addActionItem(new ActionItem(14, playerInv.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                new MenuPlayerInventory(MenuProfile.this.player, MenuProfile.this.playerStat, MenuProfile.this.playerStat.getPlayer() == null).openMenu();
            }
        });
        Item teleport = new Item(Material.ENDER_PEARL, ChatColor.YELLOW + "Teleport to player");
        this.addActionItem(new ActionItem(15, teleport.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (MenuProfile.this.playerStat.getPlayer() == null) {
                    MEnum.NO_CONNECTED.sendTo(MenuProfile.this.player, new Object[0]);
                    return;
                }
                MenuProfile.this.player.getPlayer().teleport((Entity)MenuProfile.this.playerStat.getPlayer());
                MenuProfile.this.player.getPlayer().closeInventory();
            }
        });
        Item scenarios = new Item(Material.BEACON, ChatColor.AQUA + "Scenario Informations");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        ScenarioManager.getActivatedScenarios().forEach(scenario -> lore.addAll(scenario.onProfileInformations(this.player, this.playerStat)));
        if (!this.playerStat.getInventory().isEmptyFullBackpack()) {
            Item fullItem = new Item(Material.ENDER_CHEST, ChatColor.AQUA + "Full Backpack");
            this.addActionItem(new ActionItem(20, fullItem.toItemStack()){

                public void onClick(InventoryClickEvent e) {
                    new MenuGameFullBackpack(MenuProfile.this.player, MenuProfile.this.playerStat).openMenu();
                }
            });
        }
        if (lore.size() == 1) {
            lore.add(ChatColor.RED + "Nothing.");
        }
        scenarios.setLore(lore);
        this.addItem(new StaticItem(22, scenarios.toItemStack()));
        UHCTeam team = UHC.getTeam(this.player);
        if (team != null) {
            Item teamItem = new Item(Material.BANNER, ChatColor.AQUA + "Team " + team.getPrefix().getTextName());
            ArrayList<String> teamLore = new ArrayList<String>();
            if (!team.getPlayers().isEmpty()) {
                teamLore.add("");
                teamLore.add(MEnum.PLAYERS.getText(this.player, new Object[0]));
                team.getPlayers().forEach(pl -> teamLore.add(ChatColor.DARK_GRAY + " - " + ChatColor.AQUA + pl.getName()));
            }
            teamItem.setLore(teamLore);
            this.addItem(new StaticItem(24, teamItem.toItemStack()));
        }
    }

    private String getStatLine(String name, String value, String valueType) {
        String valueTypeText = valueType == "" ? "" : ChatColor.GRAY + " " + valueType;
        return ChatColor.YELLOW + name + " " + ChatUtil.getArrow() + ChatColor.AQUA + value + valueTypeText;
    }
}

