/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.host.game;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.ui.host.game.MenuPlayerInventoryFull;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.objets.SymbolBank;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;

public class MenuPlayerInventory
extends CustomInventory {
    private UHCPlayer target;
    private boolean lastInventory;

    public MenuPlayerInventory(ScorpionPlayer sp, UHCPlayer target, boolean lastInventory) {
        super(sp, MEnum.MENU_HOST_PLAYER_INV.getText(sp, target.getName()), 6, 1);
        this.target = target;
        this.lastInventory = lastInventory;
    }

    public void setupMenu() {
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_HOST.getColor(), " ").toItemStack(), 1);
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_HOST.getColor(), " ").toItemStack(), 2);
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        Item infos = new Item(Material.PAPER, ChatColor.GOLD + this.target.getName());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(" ");
        if (this.lastInventory) {
            lore.add(ChatColor.GRAY + "Last location: ");
            Location lastloc = this.target.getInventory().getLocation();
            lore.add(ChatColor.WHITE + " - " + ChatColor.GRAY + "X = " + ChatColor.AQUA + lastloc.getBlockX());
            lore.add(ChatColor.WHITE + " - " + ChatColor.GRAY + "Y = " + ChatColor.AQUA + lastloc.getBlockY());
            lore.add(ChatColor.WHITE + " - " + ChatColor.GRAY + "Z = " + ChatColor.AQUA + lastloc.getBlockZ());
        } else {
            lore.add(ChatColor.GRAY + "Health: " + ChatColor.AQUA + (int)Math.ceil(this.target.getPlayer().getHealth() / 2.0) + " " + SymbolBank.HEARTH + ChatColor.GRAY + " / " + ChatColor.DARK_AQUA + (int)Math.ceil(this.target.getPlayer().getMaxHealth() / 2.0) + " " + SymbolBank.HEARTH);
            lore.add(ChatColor.GRAY + "Food: " + ChatColor.AQUA + this.target.getPlayer().getFoodLevel());
            lore.add(ChatColor.GRAY + "Level: " + ChatColor.AQUA + this.target.getPlayer().getLevel());
            lore.add(" ");
            if (this.target.getPlayer().getActivePotionEffects() == null) {
                lore.add(ChatColor.GRAY + "Effect(s): " + ChatColor.RED + "None");
            } else {
                lore.add(ChatColor.GRAY + "Effect(s): ");
                for (PotionEffect effect : this.target.getPlayer().getActivePotionEffects()) {
                    lore.add(ChatColor.WHITE + " - " + ChatColor.GREEN + effect.getType().getName() + " " + ChatColor.RED + (effect.getAmplifier() + 1));
                }
            }
        }
        infos.setLore(lore);
        this.addItem(new StaticItem(2, infos.toItemStack()));
        if (this.lastInventory) {
            Item drop = new Item(Material.SLIME_BALL, MEnum.DROP_STUFF_NAME.getText(this.player, new Object[0]));
            drop.setLore(new String[]{"", MEnum.DROP_STUFF_LORE.getText(this.player, new Object[0])});
            this.addActionItem(new ActionItem(0, drop.toItemStack()){

                public void onClick(InventoryClickEvent e) {
                    MenuPlayerInventory.this.player.getPlayer().closeInventory();
                    InventoryUtil.dropDeathStuff(MenuPlayerInventory.this.target, MenuPlayerInventory.this.player.getPlayer().getLocation());
                }
            });
            this.addItem(new StaticItem(3, this.getHelmet(this.target.getInventory().getHelmet())));
            this.addItem(new StaticItem(4, this.getChestplate(this.target.getInventory().getChestplate())));
            this.addItem(new StaticItem(5, this.getLeggings(this.target.getInventory().getLeggings())));
            this.addItem(new StaticItem(6, this.getBoots(this.target.getInventory().getBoots())));
            int slot = 18;
            for (ItemStack item : this.target.getInventory().getInventory()) {
                this.addItem(new StaticItem(slot, item));
                ++slot;
            }
            return;
        }
        Item fullInv = new Item(Material.ENDER_CHEST, MEnum.FULL_STUFF_NAME.getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(0, fullInv.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                new MenuPlayerInventoryFull(MenuPlayerInventory.this.player, MenuPlayerInventory.this.target, MenuPlayerInventory.this.lastInventory).openMenu();
            }
        });
        PlayerInventory playerInventory = this.target.getPlayer().getInventory();
        this.addItem(new StaticItem(3, this.getHelmet(playerInventory.getHelmet())));
        this.addItem(new StaticItem(4, this.getChestplate(playerInventory.getChestplate())));
        this.addItem(new StaticItem(5, this.getLeggings(playerInventory.getLeggings())));
        this.addItem(new StaticItem(6, this.getBoots(playerInventory.getBoots())));
        for (int i = 0; i < playerInventory.getSize(); ++i) {
            ItemStack stack = playerInventory.getItem(i);
            if (stack == null || stack.getType() == null) continue;
            this.addItem(new StaticItem(i + 18, stack));
        }
    }

    private ItemStack getHelmet(ItemStack stack) {
        if (stack == null) {
            return new Item(Material.CHAINMAIL_HELMET, ChatColor.RED + "No Helmet").toItemStack();
        }
        return stack;
    }

    private ItemStack getChestplate(ItemStack stack) {
        if (stack == null) {
            return new Item(Material.CHAINMAIL_CHESTPLATE, ChatColor.RED + "No Chestplate").toItemStack();
        }
        return stack;
    }

    private ItemStack getLeggings(ItemStack stack) {
        if (stack == null) {
            return new Item(Material.CHAINMAIL_LEGGINGS, ChatColor.RED + "No Leggings").toItemStack();
        }
        return stack;
    }

    private ItemStack getBoots(ItemStack stack) {
        if (stack == null) {
            return new Item(Material.CHAINMAIL_BOOTS, ChatColor.RED + "No Boots").toItemStack();
        }
        return stack;
    }
}

