/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.config.templates;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.templates.Template;
import eu.scorpionltd.uhc.manager.settings.templates.TemplateManager;
import eu.scorpionltd.uhc.ui.MenuPrincipal;
import eu.scorpionltd.uhc.ui.config.templates.MenuShowTemplates;
import eu.scorpionltd.utils.inventory.AnvilGUI;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuTemplates
extends CustomInventory {
    public MenuTemplates(ScorpionPlayer sp) {
        super(sp, MEnum.MENU_TEMPLATES.getText(sp, new Object[0]), 6, 1);
    }

    public void setupMenu() {
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_CONFIG.getColor(), " ").toItemStack(), 1);
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_CONFIG.getColor(), " ").toItemStack(), 2);
        this.addReturnItem(0, new MenuPrincipal(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        final Template defaultTemplate = TemplateManager.getDefaultTemplate();
        Item defaultItem = new Item(Material.BOOK, MEnum.SET_DEFAULT_TEMPLATE_NAME.getText(this.player, new Object[0]));
        defaultItem.setLore(new String[]{"", MEnum.SET_DEFAULT_TEMPLATE_LORE.getText(this.player, defaultTemplate.getName())});
        this.addActionItem(new ActionItem(3, defaultItem.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                defaultTemplate.loadSettings();
                MEnum.SEND_DEFAULT_TEMPLATE.sendTo(MenuTemplates.this.player, defaultTemplate.getName());
                MenuTemplates.this.player.getPlayer().closeInventory();
            }
        });
        this.addActionItem(new ActionItem(5, new Item(Material.COMMAND, MEnum.ADD_ACTUAL_CONFIG.getText(this.player, new Object[0])).toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuTemplates.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            Template newTemplate = new Template(event.getName());
                            newTemplate.saveSettings();
                            MenuTemplates.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.COMMAND, "Template Name").toItemStack());
                gui.open();
            }
        });
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        int slot = 18;
        ArrayList<Template> templates = new ArrayList<Template>(TemplateManager.getTemplates());
        templates.remove(defaultTemplate);
        for (final Template template : templates) {
            Item item = new Item(Material.PAPER, ChatColor.AQUA + template.getName());
            item.setLore(new String[]{"", MEnum.LEFT_CLICK.getText(this.player, new Object[0]) + MEnum.LOAD_SETTINGS.getText(this.player, new Object[0]), MEnum.RIGHT_CLICK.getText(this.player, new Object[0]) + MEnum.SHOW_SETTINGS.getText(this.player, new Object[0])});
            this.addActionItem(new ActionItem(slot, item.toItemStack()){

                public void onClick(InventoryClickEvent e) {
                    if (e.isLeftClick()) {
                        template.loadSettings();
                        MEnum.LOAD_TEMPLATE.sendTo(MenuTemplates.this.player, template.getName());
                        MenuTemplates.this.player.getPlayer().closeInventory();
                    } else {
                        new MenuShowTemplates(MenuTemplates.this.player, template).openMenu();
                    }
                }
            });
            ++slot;
        }
    }
}

