/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.config.server;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistManager;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistType;
import eu.scorpionltd.uhc.manager.integration.IntegrationManager;
import eu.scorpionltd.uhc.manager.integration.OpenTime;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.ui.MenuPrincipal;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistStatus;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.inventory.AnvilGUI;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuWhitelist
extends CustomInventory {
    public MenuWhitelist(ScorpionPlayer sp) {
        super(sp, MEnum.MENU_WHITELIST.getText(sp, new Object[0]), 5, 2);
    }

    public void setupMenu() {
        ItemStack pane = new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_CONFIG.getColor(), " ").toItemStack();
        for (int i : Arrays.asList(1, 7, 9, 17, 27, 35, 37, 43)) {
            this.addItem(new StaticItem(i, pane));
        }
        this.addReturnItem(0, new MenuPrincipal(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        WhitelistStatus status = WhitelistStatus.getCurrentStatus();
        Item categorieStatus = new Item(Material.SPRUCE_FENCE_GATE, MEnum.WHITELIST_STATUS_NAME.getText(this.player, new Object[0]));
        categorieStatus.setLore(new String[]{MEnum.STATE.getText(this.player, new Object[0]) + status.getMessage().getText(this.player, new Object[0])});
        this.addCategorieItem(1, 3, categorieStatus);
        WhitelistType type = WhitelistManager.getCurrentWhitelist();
        Item categorieType = new Item(Material.IRON_DOOR, MEnum.WHITELIST_TYPE_NAME.getText(this.player, new Object[0]));
        categorieType.setLore(new String[]{MEnum.STATE.getText(this.player, new Object[0]) + type.getDisplayName()});
        this.addCategorieItem(2, 5, categorieType);
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        this.setWhitelistTypeItems();
        this.setWhitelistStatusItems();
        this.setItemsAnnonce();
    }

    private void setWhitelistTypeItems() {
        for (final WhitelistType whitelistType : WhitelistManager.getWhitelists()) {
            this.addActionItem(new ActionItem(2, whitelistType.getSlot(), whitelistType.getItemStack()){

                public void onClick(InventoryClickEvent e) {
                    if (!whitelistType.hasPermissionToSwitch(MenuWhitelist.this.player.getPlayer())) {
                        MEnum.NO_PERMISSION.sendTo(MenuWhitelist.this.player.getPlayer(), new Object[0]);
                        return;
                    }
                    WhitelistManager.setCurrentType(whitelistType);
                    MenuWhitelist.this.player.getPlayer().sendMessage(ChatUtil.getConfigPrefix() + MEnum.WHITELIST_TYPE_NAME.getText(MenuWhitelist.this.player, new Object[0]) + " " + ChatUtil.getArrow() + whitelistType.getDisplayName());
                    MenuWhitelist.this.openMenu();
                }
            });
        }
    }

    private void setWhitelistStatusItems() {
        Item redstone = new Item(Material.REDSTONE, WhitelistStatus.CLOSE.getMessage().getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(1, 20, redstone.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                WhitelistStatus.setCurrentStatus(WhitelistStatus.CLOSE);
                MenuWhitelist.this.player.getPlayer().sendMessage(ChatUtil.getConfigPrefix() + MEnum.WHITELIST_STATUS_NAME.getText(MenuWhitelist.this.player, new Object[0]) + " " + ChatUtil.getArrow() + WhitelistStatus.CLOSE.getMessage().getText(MenuWhitelist.this.player, new Object[0]));
                MenuWhitelist.this.openMenu();
            }
        });
        Item goldenApple = new Item(Material.GOLDEN_APPLE, WhitelistStatus.PRE_WHITELIST.getMessage().getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(1, 22, goldenApple.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                WhitelistStatus.setCurrentStatus(WhitelistStatus.PRE_WHITELIST);
                MenuWhitelist.this.player.getPlayer().sendMessage(ChatUtil.getConfigPrefix() + MEnum.WHITELIST_STATUS_NAME.getText(MenuWhitelist.this.player, new Object[0]) + " " + ChatUtil.getArrow() + WhitelistStatus.PRE_WHITELIST.getMessage().getText(MenuWhitelist.this.player, new Object[0]));
                MenuWhitelist.this.openMenu();
            }
        });
        Item slimeball = new Item(Material.SLIME_BALL, WhitelistStatus.OPEN.getMessage().getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(1, 24, slimeball.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                WhitelistStatus.setCurrentStatus(WhitelistStatus.OPEN);
                MenuWhitelist.this.player.getPlayer().sendMessage(ChatUtil.getConfigPrefix() + MEnum.WHITELIST_STATUS_NAME.getText(MenuWhitelist.this.player, new Object[0]) + " " + ChatUtil.getArrow() + WhitelistStatus.OPEN.getMessage().getText(MenuWhitelist.this.player, new Object[0]));
                MenuWhitelist.this.openMenu();
            }
        });
    }

    private void setItemsAnnonce() {
        Item annonceGame = new Item(Material.BOOK, MEnum.WHITELIST_PUBLISH.getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(36, annonceGame.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (!UHC.getInstance().isPRO()) {
                    MEnum.NO_PRO_VERSION.sendTo(MenuWhitelist.this.player, new Object[0]);
                    return;
                }
                if (!Permissions.PUBLISH_ACCESS.hasPerm(MenuWhitelist.this.player.getPlayer())) {
                    MEnum.NO_PERMISSION.sendTo(MenuWhitelist.this.player, new Object[0]);
                    return;
                }
                if (UHCPlayerManager.getActualHost() == null) {
                    MEnum.NO_HOST.sendTo(MenuWhitelist.this.player, new Object[0]);
                    return;
                }
                if (OpenTime.getInstance() == null) {
                    MEnum.NO_TIME_OPEN.sendTo(MenuWhitelist.this.player, new Object[0]);
                    return;
                }
                if (ConfigFile.TWITTER_EXTERNAL_VALUE.getBoolean() || ConfigFile.DISCORD_EXTERNAL_VALUE.getBoolean()) {
                    AnvilGUI gui = new AnvilGUI(MenuWhitelist.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                        public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                            if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                                event.setWillClose(false);
                                event.setWillDestroy(true);
                                String name = event.getName();
                                IntegrationManager.publishGame(UHCPlayerManager.getPlayer(MenuWhitelist.this.player), name);
                                MenuWhitelist.this.player.getPlayer().closeInventory();
                                MenuWhitelist.this.openMenu();
                            } else {
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            }
                        }
                    });
                    gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.BOOK, "").toItemStack());
                    gui.open();
                    return;
                }
                IntegrationManager.publishGame(UHCPlayerManager.getPlayer(MenuWhitelist.this.player), "");
                MenuWhitelist.this.player.getPlayer().closeInventory();
            }
        });
        String time = OpenTime.getInstance() == null ? ChatColor.RED + "Unknown" : OpenTime.getInstance().getText();
        Item timeOpen = new Item(Material.WATCH, MEnum.WHITELIST_TIME_OPEN.getText(this.player, new Object[0]) + time);
        this.addActionItem(new ActionItem(44, timeOpen.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (!UHC.getInstance().isPRO()) {
                    MEnum.NO_PRO_VERSION.sendTo(MenuWhitelist.this.player, new Object[0]);
                    return;
                }
                if (!Permissions.OPEN_TIME_ACCESS.hasPerm(MenuWhitelist.this.player.getPlayer())) {
                    MEnum.NO_PERMISSION.sendTo(MenuWhitelist.this.player, new Object[0]);
                    return;
                }
                AnvilGUI gui = new AnvilGUI(MenuWhitelist.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            if (!name.contains(":")) {
                                MEnum.NOT_NUMBER.sendTo(MenuWhitelist.this.player, new Object[0]);
                                return;
                            }
                            String[] values = name.split(":");
                            if (!MathUtil.isInt(values[0]) || !MathUtil.isInt(values[1])) {
                                MEnum.NOT_NUMBER.sendTo(MenuWhitelist.this.player, new Object[0]);
                                return;
                            }
                            new OpenTime(Integer.parseInt(values[0]), Integer.parseInt(values[1]));
                            MenuWhitelist.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.PAPER, "XX:YY").toItemStack());
                gui.open();
            }
        });
    }
}

