/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.config.objet.item;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.ui.config.objet.MenuInventaires;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.inventory.AnvilGUI;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuAddEnchant
extends CustomInventory {
    private Values value;
    private ItemStack item;

    public MenuAddEnchant(ScorpionPlayer player, Values value, ItemStack item) {
        super(player, "Ajouter un objet", 5, 1);
        this.value = value;
        this.item = item;
    }

    public void setupMenu() {
        ItemStack glassPane = new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_CONFIG.getColor(), " ").toItemStack();
        this.remplirLignesInventory(glassPane, 1);
        this.remplirLignesInventory(glassPane, 2);
        this.remplirLignesInventory(glassPane, 4);
        this.remplirLignesInventory(glassPane, 5);
        this.addCloseItem(0, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        final Item name = new Item(Material.NAME_TAG, ChatColor.GOLD + "Modifier le nom");
        this.addActionItem(new ActionItem(2, name.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuAddEnchant.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String nom = event.getName().replace('&', '\u00a7');
                            Item newItem = new Item(MenuAddEnchant.this.item);
                            newItem.setName(nom);
                            MenuAddEnchant.this.item = newItem.toItemStack();
                            MenuAddEnchant.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, name.toItemStack());
                gui.open();
            }
        });
        this.addItem(new StaticItem(4, this.item));
        final Item amount = new Item(Material.GLOWSTONE, ChatColor.GOLD + "Modifier la quantit\u00e9");
        this.addActionItem(new ActionItem(6, amount.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuAddEnchant.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            if (!MathUtil.isInt(name)) {
                                MEnum.NOT_NUMBER.sendTo(MenuAddEnchant.this.player, new Object[0]);
                                MenuAddEnchant.this.openMenu();
                                return;
                            }
                            MenuAddEnchant.this.item.setAmount(Integer.parseInt(name));
                            MenuAddEnchant.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, amount.toItemStack());
                gui.open();
            }
        });
        final Item addDesc = new Item(Material.PAPER, ChatColor.GOLD + "Ajoutez une ligne de description");
        this.addActionItem(new ActionItem(18, addDesc.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuAddEnchant.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String nom = event.getName().replace('&', '\u00a7');
                            Item newItem = new Item(MenuAddEnchant.this.item);
                            List lore = newItem.getLore() != null ? newItem.getLore() : new ArrayList();
                            lore.add(nom);
                            newItem.setLore(lore);
                            MenuAddEnchant.this.item = newItem.toItemStack();
                            MenuAddEnchant.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, addDesc.toItemStack());
                gui.open();
            }
        });
        Item removeDesc = new Item(Material.FLINT_AND_STEEL, ChatColor.GOLD + "Retirer une ligne de description");
        this.addActionItem(new ActionItem(20, removeDesc.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                Item newItem = new Item(MenuAddEnchant.this.item);
                if (newItem.getLore() != null) {
                    newItem.setLore(newItem.getLore().size() == 1 ? new ArrayList() : newItem.getLore().subList(0, newItem.getLore().size() - 1));
                }
                MenuAddEnchant.this.item = newItem.toItemStack();
                MenuAddEnchant.this.openMenu();
            }
        });
        Item enchant = new Item(Material.ENCHANTED_BOOK, ChatColor.GOLD + "Ajouter un enchantement");
        this.addActionItem(new ActionItem(22, enchant.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                MEnum.COMING_SOON.sendTo(MenuAddEnchant.this.player, new Object[0]);
            }
        });
        Item annuler = new Item(Material.REDSTONE, ChatColor.RED + "Annuler");
        this.addActionItem(new ActionItem(39, annuler.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                new MenuInventaires(MenuAddEnchant.this.player).openMenu();
            }
        });
        Item confirmer = new Item(Material.SLIME_BALL, ChatColor.GREEN + "Confirmer");
        this.addActionItem(new ActionItem(41, confirmer.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                MenuAddEnchant.this.value.getSettings().addItemStack(MenuAddEnchant.this.player, MenuAddEnchant.this.item);
                new MenuInventaires(MenuAddEnchant.this.player).openMenu();
            }
        });
    }
}

