/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.admin.server.limits;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.limits.Limits;
import eu.scorpionltd.uhc.manager.settings.limits.LimitsManager;
import eu.scorpionltd.uhc.ui.admin.server.MenuConfigServer;
import eu.scorpionltd.uhc.ui.admin.server.limits.MenuChooseLimit;
import eu.scorpionltd.utils.inventory.AnvilGUI;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuConfigLimits
extends CustomInventory {
    public MenuConfigLimits(ScorpionPlayer sp) {
        super(sp, MEnum.MENU_ADMIN_CONFIG_LIMITS.getText(sp, new Object[0]), Math.min(6, 2 + LimitsManager.getLimitsLines()), 1);
    }

    public void setupMenu() {
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_ADMIN.getColor(), " ").toItemStack(), 1);
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_ADMIN.getColor(), " ").toItemStack(), 2);
        this.addReturnItem(0, new MenuConfigServer(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        Item create = new Item(Material.ANVIL, MEnum.CREATE_LIMIT.getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(4, create.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (!UHC.getInstance().isPRO()) {
                    MEnum.NO_PRO_VERSION.sendTo(MenuConfigLimits.this.player, new Object[0]);
                    return;
                }
                new MenuChooseLimit(MenuConfigLimits.this.player).openMenu();
            }
        });
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        int i = 18;
        for (final Limits limit : LimitsManager.getLimits()) {
            if (i >= 54) {
                return;
            }
            this.addActionItem(new ActionItem(i, limit.getItemStack(this.player)){

                public void onClick(InventoryClickEvent e) {
                    if (e.isLeftClick()) {
                        AnvilGUI gui = new AnvilGUI(MenuConfigLimits.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                            public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                                if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                                    event.setWillClose(false);
                                    event.setWillDestroy(true);
                                    String name = event.getName();
                                    if (!limit.isGoodType(name)) {
                                        MEnum.NOT_DEFINE.sendTo(MenuConfigLimits.this.player, new Object[0]);
                                        MenuConfigLimits.this.openMenu();
                                        return;
                                    }
                                    limit.changeLimit(name);
                                    MenuConfigLimits.this.openMenu();
                                } else {
                                    event.setWillClose(false);
                                    event.setWillDestroy(false);
                                }
                            }
                        });
                        gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, limit.getAnvilItem(MenuConfigLimits.this.player));
                        gui.open();
                    } else {
                        limit.removeLimit();
                        new MenuConfigLimits(MenuConfigLimits.this.player).openMenu();
                    }
                }
            });
            ++i;
        }
    }
}

