/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.admin.player.permissions;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permission;
import eu.scorpionltd.uhc.manager.players.permissions.PermissionManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.ui.admin.player.MenuConfigStaff;
import eu.scorpionltd.uhc.util.world.BlockUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;

public class MenuPermissions
extends CustomInventory {
    private Permission selectedPermission;

    public MenuPermissions(ScorpionPlayer sp, Permission selected, int categorie) {
        super(sp, MEnum.MENU_ADMIN_CONFIG_PERMISSIONS.getText(sp, new Object[0]), 5, (int)Math.max(Math.ceil((double)PermissionManager.getPermissions().size() / 21.0), 1.0));
        this.selectedPermission = selected;
        this.setActualCategorie(categorie);
    }

    public MenuPermissions(ScorpionPlayer sp) {
        this(sp, PermissionManager.getPermissions().get(0), 1);
    }

    public void setupMenu() {
        this.remplirCornerInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_ADMIN.getColor(), " ").toItemStack());
        this.addReturnItem(0, new MenuConfigStaff(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        Item leftArrow = new Item(Material.SKULL_ITEM, 3, MEnum.PAGE_PREVIOUS.getText(this.player, new Object[0]));
        leftArrow.setLore(new String[]{"", MEnum.PREVIOUS_PAGE.getText(this.player, new Object[0])});
        leftArrow.setTexture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2RjOWU0ZGNmYTQyMjFhMWZhZGMxYjViMmIxMWQ4YmVlYjU3ODc5YWYxYzQyMzYyMTQyYmFlMWVkZDUifX19");
        this.addActionItem(new ActionItem(18, leftArrow.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                MenuPermissions.this.setActualCategorie(MenuPermissions.this.getPreviousCategorie());
                MenuPermissions.this.openMenu();
            }
        });
        Item rightArrow = new Item(Material.SKULL_ITEM, 3, MEnum.PAGE_NEXT.getText(this.player, new Object[0]));
        rightArrow.setLore(new String[]{"", MEnum.NEXT_PAGE.getText(this.player, new Object[0])});
        rightArrow.setTexture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTU2YTM2MTg0NTllNDNiMjg3YjIyYjdlMjM1ZWM2OTk1OTQ1NDZjNmZjZDZkYzg0YmZjYTRjZjMwYWI5MzExIn19fQ==");
        this.addActionItem(new ActionItem(26, rightArrow.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                MenuPermissions.this.setActualCategorie(MenuPermissions.this.getNextCategorie());
                MenuPermissions.this.openMenu();
            }
        });
        int categorie = 1;
        List<Integer> slots = this.getSlotsList();
        ArrayList<Material> materials = new ArrayList<Material>(BlockUtil.getRandomMaterials());
        for (final Permission perm : PermissionManager.getPermissions()) {
            Item item = new Item(perm.getItemStack(this.player, materials.remove(0)));
            if (perm == this.selectedPermission) {
                item.addUnSafeEnchantement(Enchantment.DURABILITY, 1);
            }
            this.addActionItem(new ActionItem(categorie, slots.remove(0), item.toItemStackwithItemFlag(ItemFlag.values())){

                public void onClick(InventoryClickEvent e) {
                    new MenuPermissions(MenuPermissions.this.player, perm, MenuPermissions.this.actual_categorie).openMenu();
                }
            });
            if (slots.isEmpty()) {
                slots = this.getSlotsList();
                ++categorie;
            }
            if (!materials.isEmpty()) continue;
            materials = new ArrayList<Material>(BlockUtil.getRandomMaterials());
        }
        final boolean hasNeededPermission = this.selectedPermission.isHasNeededPermission();
        Item changeNeedPermission = new Item(Material.PAPER, hasNeededPermission ? 1 : 0, ChatColor.YELLOW + "Permission n\u00e9cessaire: " + (hasNeededPermission ? MEnum.VALUE_ON.getText(this.player, new Object[0]) : MEnum.VALUE_OFF.getText(this.player, new Object[0])));
        changeNeedPermission.setLore(new String[]{"", MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(38, changeNeedPermission.toItemStackwithItemFlag(ItemFlag.values())){

            public void onClick(InventoryClickEvent e) {
                MenuPermissions.this.selectedPermission.setHasNeededPermission(!hasNeededPermission);
                MenuPermissions.this.openMenu();
            }
        });
        final boolean hasHost = this.selectedPermission.isHasHost();
        Item changeHost = new Item(Material.BLAZE_ROD, hasHost ? 1 : 0, ChatColor.YELLOW + "Statut Host n\u00e9cessaire: " + (hasHost ? MEnum.VALUE_ON.getText(this.player, new Object[0]) : MEnum.VALUE_OFF.getText(this.player, new Object[0])));
        changeHost.setLore(new String[]{"", MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(39, changeHost.toItemStackwithItemFlag(ItemFlag.values())){

            public void onClick(InventoryClickEvent e) {
                MenuPermissions.this.selectedPermission.setHasHost(!hasHost);
                MenuPermissions.this.openMenu();
            }
        });
        final boolean hasCoHost = this.selectedPermission.isHasCoHost();
        Item changeCoHost = new Item(Material.BLAZE_POWDER, hasCoHost ? 1 : 0, ChatColor.YELLOW + "Statut Co-Host n\u00e9cessaire: " + (hasCoHost ? MEnum.VALUE_ON.getText(this.player, new Object[0]) : MEnum.VALUE_OFF.getText(this.player, new Object[0])));
        changeCoHost.setLore(new String[]{"", MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(40, changeCoHost.toItemStackwithItemFlag(ItemFlag.values())){

            public void onClick(InventoryClickEvent e) {
                MenuPermissions.this.selectedPermission.setHasCoHost(!hasCoHost);
                MenuPermissions.this.openMenu();
            }
        });
        final boolean hasSpec = this.selectedPermission.isHasSpec();
        Item changeSpec = new Item(Material.STICK, hasSpec ? 1 : 0, ChatColor.YELLOW + "Statut Spec n\u00e9cessaire: " + (hasSpec ? MEnum.VALUE_ON.getText(this.player, new Object[0]) : MEnum.VALUE_OFF.getText(this.player, new Object[0])));
        changeSpec.setLore(new String[]{"", MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(41, changeSpec.toItemStackwithItemFlag(ItemFlag.values())){

            public void onClick(InventoryClickEvent e) {
                MenuPermissions.this.selectedPermission.setHasSpec(!hasSpec);
                MenuPermissions.this.openMenu();
            }
        });
        final boolean hasNotPlaying = this.selectedPermission.isHasNotPlaying();
        Item changeNotPlaying = new Item(Material.IRON_SWORD, hasNotPlaying ? 1 : 0, ChatColor.YELLOW + "Statut 'Non-Joueur' n\u00e9cessaire: " + (hasNotPlaying ? MEnum.VALUE_ON.getText(this.player, new Object[0]) : MEnum.VALUE_OFF.getText(this.player, new Object[0])));
        changeNotPlaying.setLore(new String[]{"", MEnum.MODIFY_ELEMENT.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(42, changeNotPlaying.toItemStackwithItemFlag(ItemFlag.values())){

            public void onClick(InventoryClickEvent e) {
                MenuPermissions.this.selectedPermission.setHasNotPlaying(!hasNotPlaying);
                MenuPermissions.this.openMenu();
            }
        });
    }

    public List<Integer> getSlotsList() {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (i = 10; i < 17; ++i) {
            slots.add(i);
        }
        for (i = 19; i < 26; ++i) {
            slots.add(i);
        }
        for (i = 28; i < 35; ++i) {
            slots.add(i);
        }
        return slots;
    }
}

