/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.admin.player.holograms;

import eu.scorpionltd.uhc.manager.game.holograms.Hologram;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.ui.admin.player.holograms.MenuConfigHolograms;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.inventory.AnvilGUI;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;

public class MenuCreateHologram
extends CustomInventory {
    private Hologram hologram;

    public MenuCreateHologram(ScorpionPlayer sp, Hologram hologram) {
        super(sp, MEnum.MENU_ADMIN_CONFIG_HOLOGRAMS.getText(sp, new Object[0]), 3, 1);
        this.hologram = hologram;
    }

    public void setupMenu() {
        this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_ADMIN.getColor(), " ").toItemStack());
        this.addReturnItem(0, new MenuConfigHolograms(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        Item changeName = new Item(Material.NAME_TAG, ChatColor.GOLD + "Title: " + ChatColor.GRAY + this.hologram.getTitle());
        this.addActionItem(new ActionItem(2, changeName.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuCreateHologram.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            MenuCreateHologram.this.hologram.setTitle(name);
                            MenuCreateHologram.this.hologram.resetHologram();
                            MenuCreateHologram.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.NAME_TAG, MenuCreateHologram.this.hologram.getTitle()).toItemStack());
                gui.open();
            }
        });
        Item changeType = new Item(this.hologram.getType().getMaterial(), ChatColor.YELLOW + this.hologram.getType().getName());
        this.addActionItem(new ActionItem(4, changeType.toItemStackwithItemFlag(ItemFlag.values())){

            public void onClick(InventoryClickEvent e) {
                if (e.isLeftClick()) {
                    MenuCreateHologram.this.hologram.setType(MenuCreateHologram.this.hologram.getType().getNextHologramType());
                } else {
                    MenuCreateHologram.this.hologram.setType(MenuCreateHologram.this.hologram.getType().getPreviousHologramType());
                }
                MenuCreateHologram.this.hologram.resetHologram();
                MenuCreateHologram.this.openMenu();
            }
        });
        Item removeHologram = new Item(Material.REDSTONE, MEnum.REMOVE_HOLOGRAM.getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(6, removeHologram.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                MenuCreateHologram.this.hologram.removeHologram();
                new MenuConfigHolograms(MenuCreateHologram.this.player).openMenu();
            }
        });
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        Item changeX = new Item(Material.STONE, 1, ChatColor.YELLOW + "X: " + ChatColor.AQUA + this.hologram.getX());
        this.addActionItem(new ActionItem(18, changeX.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuCreateHologram.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            if (!MathUtil.isDouble(name)) {
                                MEnum.NOT_NUMBER.sendTo(MenuCreateHologram.this.player, new Object[0]);
                                return;
                            }
                            MenuCreateHologram.this.hologram.setX(Double.parseDouble(name));
                            MenuCreateHologram.this.hologram.resetHologram();
                            MenuCreateHologram.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.STONE, 1, MenuCreateHologram.this.hologram.getX() + "").toItemStack());
                gui.open();
            }
        });
        Item changeY = new Item(Material.STONE, 3, ChatColor.YELLOW + "Y: " + ChatColor.AQUA + this.hologram.getY());
        this.addActionItem(new ActionItem(20, changeY.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuCreateHologram.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            if (!MathUtil.isDouble(name)) {
                                MEnum.NOT_NUMBER.sendTo(MenuCreateHologram.this.player, new Object[0]);
                                return;
                            }
                            MenuCreateHologram.this.hologram.setY(Double.parseDouble(name));
                            MenuCreateHologram.this.hologram.resetHologram();
                            MenuCreateHologram.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.STONE, 3, MenuCreateHologram.this.hologram.getY() + "").toItemStack());
                gui.open();
            }
        });
        Item changeZ = new Item(Material.STONE, 5, ChatColor.YELLOW + "Z: " + ChatColor.AQUA + this.hologram.getZ());
        this.addActionItem(new ActionItem(22, changeZ.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuCreateHologram.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            if (!MathUtil.isDouble(name)) {
                                MEnum.NOT_NUMBER.sendTo(MenuCreateHologram.this.player, new Object[0]);
                                return;
                            }
                            MenuCreateHologram.this.hologram.setZ(Double.parseDouble(name));
                            MenuCreateHologram.this.hologram.resetHologram();
                            MenuCreateHologram.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.STONE, 5, MenuCreateHologram.this.hologram.getZ() + "").toItemStack());
                gui.open();
            }
        });
    }
}

