/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.admin.affichage.rules;

import eu.scorpionltd.uhc.events.item.inventory.CreativeEvent;
import eu.scorpionltd.uhc.manager.game.rules.Rules;
import eu.scorpionltd.uhc.manager.game.rules.RulesManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.ui.admin.affichage.rules.MenuChooseSettings;
import eu.scorpionltd.uhc.ui.admin.affichage.rules.MenuConfigRules;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.inventory.AnvilGUI;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuCreateRules
extends CustomInventory {
    private Rules rule;

    public MenuCreateRules(ScorpionPlayer sp, Rules rule) {
        super(sp, MEnum.MENU_ADMIN_CONFIG_RULES.getText(sp, new Object[0]), 3, 1);
        this.rule = rule;
    }

    public void setupMenu() {
        this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_ADMIN.getColor(), " ").toItemStack());
        this.addReturnItem(0, new MenuConfigRules(this.player), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        Item changeName = new Item(Material.NAME_TAG, ChatColor.GOLD + "Name: " + ChatColor.GRAY + this.rule.getName());
        this.addActionItem(new ActionItem(2, changeName.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuCreateRules.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            MenuCreateRules.this.rule.setName(name);
                            MenuCreateRules.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.NAME_TAG, MenuCreateRules.this.rule.getName()).toItemStack());
                gui.open();
            }
        });
        this.addActionItem(new ActionItem(4, this.rule.getItem().clone()){

            public void onClick(InventoryClickEvent e) {
                CreativeEvent.getRuleItemsMode().put(MenuCreateRules.this.player.getUUID(), MenuCreateRules.this.rule);
                UHCPlayerManager.getPlayer(MenuCreateRules.this.player).giveBypassMode();
                MenuCreateRules.this.player.getPlayer().closeInventory();
            }
        });
        Item removeRule = new Item(Material.REDSTONE, MEnum.REMOVE_RULE.getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(6, removeRule.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                MenuCreateRules.this.rule.removeRule();
                new MenuConfigRules(MenuCreateRules.this.player).openMenu();
            }
        });
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        final int maxSlot = RulesManager.getNumberLines() * 9;
        Item changeSlot = new Item(Material.PAPER, ChatColor.YELLOW + "Slot (1-" + maxSlot + "): " + ChatColor.AQUA + this.rule.getSlot());
        this.addActionItem(new ActionItem(18, changeSlot.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                AnvilGUI gui = new AnvilGUI(MenuCreateRules.this.player.getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                    public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                        if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                            event.setWillClose(false);
                            event.setWillDestroy(true);
                            String name = event.getName();
                            if (!MathUtil.isInt(name)) {
                                MEnum.NOT_NUMBER.sendTo(MenuCreateRules.this.player, new Object[0]);
                                return;
                            }
                            int nombre = Integer.parseInt(name);
                            if (nombre < 1 || nombre > maxSlot) {
                                MEnum.NOT_NUMBER.sendTo(MenuCreateRules.this.player, new Object[0]);
                                return;
                            }
                            MenuCreateRules.this.rule.setSlot(nombre);
                            MenuCreateRules.this.openMenu();
                        } else {
                            event.setWillClose(false);
                            event.setWillDestroy(false);
                        }
                    }
                });
                gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(Material.PAPER, "" + MenuCreateRules.this.rule.getSlot()).toItemStack());
                gui.open();
            }
        });
        Item settings = new Item(Material.CHEST, ChatColor.GOLD + "Settings List");
        ArrayList<String> lore = new ArrayList<String>();
        for (Settings setting : this.rule.getSettings()) {
            lore.add(setting.getName(this.player) + ": " + setting.getTextValue(this.player));
        }
        lore.add("");
        lore.add(MEnum.LEFT_CLICK.getText(this.player, new Object[0]) + MEnum.ADD.getText(this.player, new Object[0]) + "settings");
        lore.add(MEnum.RIGHT_CLICK.getText(this.player, new Object[0]) + MEnum.REMOVE.getText(this.player, new Object[0]) + "last settings");
        settings.setLore(lore);
        this.addActionItem(new ActionItem(20, settings.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (e.isLeftClick()) {
                    new MenuChooseSettings(MenuCreateRules.this.player, MenuCreateRules.this.rule).openMenu();
                } else {
                    MenuCreateRules.this.rule.getSettings().remove(MenuCreateRules.this.rule.getSettings().size() - 1);
                    new MenuConfigRules(MenuCreateRules.this.player).openMenu();
                }
            }
        });
    }
}

