/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui.admin.affichage.message;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessageManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.ui.admin.MenuAdmin;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuConfigMessages
extends CustomInventory {
    private String path;

    public MenuConfigMessages(ScorpionPlayer sp, String path) {
        super(sp, MEnum.MENU_ADMIN_CONFIG_MESSAGES.getText(sp, new Object[0]), 6, UHCMessageManager.getNumberCategories(path));
        this.path = path;
    }

    public void setupMenu() {
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_ADMIN.getColor(), " ").toItemStack(), 1);
        this.remplirLignesInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_ADMIN.getColor(), " ").toItemStack(), 2);
        String lastPath = "realreturn";
        if (this.path != "") {
            if (!this.path.contains(".")) {
                lastPath = "";
            } else {
                String[] split = this.path.split("\\.");
                lastPath = this.path.replace("." + split[split.length - 1], "");
            }
        }
        this.addReturnItem(0, lastPath == "realreturn" ? new MenuAdmin(this.player) : new MenuConfigMessages(this.player, lastPath), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
        this.addPageItem(4, MEnum.NEXT_PAGE.getText(this.player, new Object[0]), MEnum.PREVIOUS_PAGE.getText(this.player, new Object[0]));
        Item reloadMessage = new Item(Material.BOOK, MEnum.RELOAD_MESSAGES.getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(6, reloadMessage.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                UHCMessageManager.reloadMessages();
            }
        });
        this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        int categorie = 1;
        int slot = 18;
        for (final String files : UHCMessageManager.getFiles(this.path)) {
            Item file = new Item(Material.CHEST, ChatColor.AQUA + "File: " + files);
            this.addActionItem(new ActionItem(categorie, slot, file.toItemStack()){

                public void onClick(InventoryClickEvent e) {
                    new MenuConfigMessages(MenuConfigMessages.this.player, files).openMenu();
                }
            });
            if (++slot < 54) continue;
            slot = 18;
            ++categorie;
        }
        for (final UHCMessage message : UHCMessageManager.getFinalMessages(this.path)) {
            Item item = new Item(Material.PAPER, ChatColor.AQUA + "Message: " + message.getKey().replace(this.path + ".", ""));
            if (message.getKey().contains("lore") || message.getKey().contains("Lore") || message.getKey().contains("description") || message.getKey().contains("Description")) {
                String lore = message.getText(this.player, new Object[0]);
                ArrayList<String> list = new ArrayList<String>();
                for (String line : lore.split("\n")) {
                    list.add(line);
                }
                item.setLore(list);
            }
            this.addActionItem(new ActionItem(categorie, slot, item.toItemStack()){

                public void onClick(InventoryClickEvent e) {
                    message.sendTo(MenuConfigMessages.this.player, new Object[0]);
                }
            });
            if (++slot < 54) continue;
            slot = 18;
            ++categorie;
        }
    }
}

