/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.ui;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.game.AutoRulesManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.modules.ModuleManager;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.ui.admin.MenuAdmin;
import eu.scorpionltd.uhc.ui.config.MenuChat;
import eu.scorpionltd.uhc.ui.config.MenuRules;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.uhc.ui.config.objet.MenuBlocs;
import eu.scorpionltd.uhc.ui.config.objet.MenuEntites;
import eu.scorpionltd.uhc.ui.config.objet.MenuInventaires;
import eu.scorpionltd.uhc.ui.config.objet.MenuItems;
import eu.scorpionltd.uhc.ui.config.server.MenuServer;
import eu.scorpionltd.uhc.ui.config.server.MenuTeams;
import eu.scorpionltd.uhc.ui.config.server.MenuTimers;
import eu.scorpionltd.uhc.ui.config.server.MenuWhitelist;
import eu.scorpionltd.uhc.ui.config.templates.MenuTemplates;
import eu.scorpionltd.uhc.ui.config.world.MenuBorders;
import eu.scorpionltd.uhc.ui.config.world.MenuGeneration;
import eu.scorpionltd.uhc.ui.config.world.MenuMondes;
import eu.scorpionltd.uhc.util.chat.color.Colors;
import eu.scorpionltd.uhc.util.item.ItemUtil;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Pregen;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.ui.ConfirmAction;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MenuPrincipal
extends CustomInventory {
    public MenuPrincipal(ScorpionPlayer sp) {
        super(sp, MEnum.MENU_PRINCIPAL.getText(sp, new Object[0]), 6, 1);
    }

    public void setupMenu() {
        this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_CONFIG.getColor(), " ").toItemStack());
        Arrays.asList(2, 4, 6, 20, 22, 24, 28, 30, 32, 34, 48, 50).forEach(vitre -> this.addItem(new StaticItem(vitre.intValue(), new Item(Material.STAINED_GLASS_PANE, Colors.WHITE.getBlock(), " ").toItemStack())));
        Item template = new Item(Material.COMMAND, MEnum.TEMPLATES.getText(this.player, new Object[0]));
        template.setLore(new String[]{"", MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(0, template.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (!UHC.getInstance().isPRO()) {
                    MEnum.NO_PRO_VERSION.sendTo(MenuPrincipal.this.player, new Object[0]);
                    return;
                }
                if (!Permissions.TEMPLATE_ACCESS.hasPerm(MenuPrincipal.this.player.getPlayer())) {
                    MEnum.NO_PERMISSION.sendTo(MenuPrincipal.this.player, new Object[0]);
                    return;
                }
                if (Status.getCurrentStatus() != Status.WAITING) {
                    MEnum.EVENTS_BLOCKED_GAME_START.sendTo(MenuPrincipal.this.player, new Object[0]);
                    return;
                }
                new MenuTemplates(MenuPrincipal.this.player).openMenu();
            }
        });
        this.addMenuItem(3, new MenuServer(this.player), Material.REDSTONE_TORCH_ON, MEnum.SERVER_HOST.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(5, new MenuBorders(this.player), Material.PRISMARINE, MEnum.BORDER.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        Item config = new Item(Material.REDSTONE_COMPARATOR, MEnum.ADMIN_CONFIG.getText(this.player, new Object[0]));
        config.setLore(new String[]{"", MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(8, config.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (!Permissions.ADMIN_ACCESS.hasPerm(MenuPrincipal.this.player.getPlayer())) {
                    MEnum.NO_PERMISSION.sendTo(MenuPrincipal.this.player, new Object[0]);
                    MenuPrincipal.this.player.getPlayer().closeInventory();
                    return;
                }
                new MenuAdmin(MenuPrincipal.this.player).openMenu();
            }
        });
        this.addMenuItem(11, new MenuTeams(this.player), Material.BANNER, MEnum.TEAMS.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(13, new MenuScenarios(this.player, 3), Material.BEACON, MEnum.SCENARIOS.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(15, new MenuTimers(this.player), Material.WATCH, MEnum.TIMERS.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(19, new MenuMondes(this.player), Material.IRON_DOOR, MEnum.MONDES.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(21, new MenuItems(this.player), Material.STICK, MEnum.OBJETS.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(23, new MenuBlocs(this.player), Material.COBBLESTONE, MEnum.BLOCKS.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(25, new MenuEntites(this.player), new Item(Material.MONSTER_EGG, 50, MEnum.ENTITIES.getText(this.player, new Object[0])).toItemStack(), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(29, new MenuInventaires(this.player), Material.CHEST, MEnum.INVENTAIRES.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(31, new MenuRules(this.player), Material.ITEM_FRAME, MEnum.RULES.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addMenuItem(33, new MenuChat(this.player), Material.SIGN, MEnum.TCHAT.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addItem(new StaticItem(45, ItemUtil.getVersionItem()));
        Item generation = new Item(Material.MINECART, MEnum.GENERATION.getText(this.player, new Object[0]));
        generation.setLore(new String[]{"", MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0])});
        this.addActionItem(new ActionItem(47, generation.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                if (Status.getCurrentStatus() != Status.WAITING && !MenuPrincipal.this.player.getPlayer().getName().equals("Rremis")) {
                    MEnum.EVENTS_BLOCKED_GAME_START.sendTo(MenuPrincipal.this.player, new Object[0]);
                    return;
                }
                new MenuGeneration(MenuPrincipal.this.player).openMenu();
            }
        });
        Item start = new Item(Material.SLIME_BALL, MEnum.START_GAME.getText(this.player, new Object[0]));
        this.addActionItem(new ActionItem(49, start.toItemStack()){

            public void onClick(final InventoryClickEvent e) {
                if (Status.getCurrentStatus() != Status.WAITING) {
                    MEnum.EVENTS_BLOCKED_GAME_START.sendTo(MenuPrincipal.this.player, new Object[0]);
                    return;
                }
                if (ConfigFile.ARENA_PREGEN_BEFORE_START.getBoolean() && Pregen.getCurrentPregen() != Pregen.DONE) {
                    MEnum.PREGEN_BEFORE_START.sendTo(MenuPrincipal.this.player, new Object[0]);
                    return;
                }
                int players = UHCPlayerManager.getPlayersConnectedNumber();
                int slots = Values.SERVER_SLOTS.getInteger();
                if (ConfigFile.COOLDOWN_START_ONLY_FULL.getBoolean() && players < slots) {
                    MEnum.EVENTS_BLOCKED_GAME_START_NOT_FULL.sendTo(MenuPrincipal.this.player, new Object[0]);
                    return;
                }
                if (ConfigFile.COOLDOWN_CONFIRMATION.getBoolean()) {
                    new ConfirmAction(MenuPrincipal.this.player, 5){

                        @Override
                        public void onStart() {
                            MEnum.CONFIRM_TO_START.sendTo(MenuPrincipal.this.player, new Object[0]);
                        }

                        @Override
                        public void onConfirm() {
                            e.getWhoClicked().closeInventory();
                            if (Values.LOBBY_AUTO_RULES.getBoolean() && !AutoRulesManager.isFinish()) {
                                if (AutoRulesManager.isProgressing()) {
                                    MEnum.AUTO_RULES_PROGRESS.sendTo(MenuPrincipal.this.player, new Object[0]);
                                    return;
                                }
                                AutoRulesManager.startAutoRules();
                                return;
                            }
                            MEnum.CONFIRM_SUCCESS.sendTo(MenuPrincipal.this.player, new Object[0]);
                            ServerUtil.sendStartRequest();
                        }

                        @Override
                        public void onCancel() {
                            MEnum.CONFIRM_CANCEL.sendTo(MenuPrincipal.this.player, new Object[0]);
                        }
                    };
                    return;
                }
                e.getWhoClicked().closeInventory();
                ServerUtil.sendStartRequest();
            }
        });
        this.addMenuItem(51, new MenuWhitelist(this.player), Material.BOOK_AND_QUILL, MEnum.WHITELIST.getText(this.player, new Object[0]), MEnum.CONFIG_CATEGORIE.getText(this.player, new Object[0]));
        this.addCloseItem(53, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        if (Status.getCurrentStatus() == Status.WAITING && ModuleManager.containsModule("Module-Mumble")) {
            final Scenario sc = ScenarioManager.getScenario("Mumble");
            Item mumble = new Item(Material.SKULL_ITEM, 3, "\u00a7c\u2022 \u00a7fMumble");
            mumble.setLore(new String[]{"", "\u00a77\u00a7l\u00bb " + (sc.isEnable() ? "\u00a7a\u00a7lActiv\u00e9" : "\u00a7c\u00a7lD\u00e9sactiv\u00e9")});
            this.addActionItem(new ActionItem(27, mumble.toSkullValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWFhNTRkNzQyNDkyOTg5ZjczOWRlYjcyMjJhMjNiY2ZjZjg1ZTZjNzgyZmUyY2UwY2RlZWUwZjNmMmIwZWIifX19")){

                public void onClick(InventoryClickEvent e) {
                    sc.inverseValue(MenuPrincipal.this.getScorpionPlayer());
                    MenuPrincipal.this.player.getPlayer().closeInventory();
                }
            });
        }
    }
}

