/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.tasks.runnable.game;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CycleDayTask
extends BukkitRunnable {
    public final float customTimeDay;
    public final float customTimeNight;
    public float countDayTime = 0.0f;
    public float countNightTime = 0.0f;

    public CycleDayTask() {
        float minutes = (float)Values.TIMERS_DUREE_CYCLE.getInteger() / 60.0f;
        int repartition = Values.TIMERS_REPARTITION_CYCLE.getInteger();
        float tempsJour = 11.666667f;
        float tempsNuit = 8.333333f;
        float timedJour = minutes * (float)repartition / 100.0f;
        float timedNuit = minutes * (float)(100 - repartition) / 100.0f;
        this.customTimeDay = tempsJour / timedJour;
        this.customTimeNight = tempsNuit / timedNuit;
        this.runTaskTimerAsynchronously((Plugin)UHC.getInstance(), 0L, 1L);
    }

    public void run() {
        for (GameWorld gameWorld : GameWorldManager.getTeleportationWorlds()) {
            World w = gameWorld.getWorld();
            if (w.getTime() <= 12000L || w.getTime() >= 22000L) {
                this.countDayTime += this.customTimeDay;
                while (this.countDayTime > 1.0f) {
                    w.setTime(w.getTime() + 1L);
                    this.countDayTime -= 1.0f;
                }
                continue;
            }
            this.countNightTime += this.customTimeNight;
            while (this.countNightTime > 1.0f) {
                w.setTime(w.getTime() + 1L);
                this.countNightTime -= 1.0f;
            }
        }
    }
}

