/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.tasks.runnable;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.util.player.MovementUtil;
import eu.scorpionltd.uhc.util.world.TeleportationUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TeleportationTask
implements Runnable {
    private final Iterator<Map.Entry<UHCPlayer, Location>> teleportations;
    private final Runnable callback;
    private final BukkitTask task;
    private final int totalPlayers;
    private int numberPlayers;
    private TeleportationUtil.TeleportRunnable runnable = new TeleportationUtil.TeleportRunnable(){

        @Override
        public void run(UHCPlayer player) {
            try {
                MovementUtil.freeze(player.getPlayer());
            }
            catch (Exception e) {
                System.out.println("ScorpionLTD-UHC \uffed TP: Erreur dans le freeze du joueur " + player.getName() + " (TeleportRunnable)");
                System.out.println(e.getMessage());
            }
            MEnum.TELEPORTATION_INFO.sendAll(TeleportationTask.this.numberPlayers, TeleportationTask.this.totalPlayers);
        }
    };

    public TeleportationTask(HashMap<UHCPlayer, Location> teleportations, Runnable callback) {
        this.teleportations = new HashMap<UHCPlayer, Location>(teleportations).entrySet().iterator();
        this.callback = callback;
        this.numberPlayers = 0;
        this.totalPlayers = teleportations.size();
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)UHC.getInstance(), (Runnable)this, 4L, 4L);
        System.out.println("ScorpionLTD-UHC \uffed D\u00e9but de la t\u00e9l\u00e9portation des joueurs (TeleportationTask)");
    }

    @Override
    public void run() {
        if (!this.teleportations.hasNext()) {
            this.task.cancel();
            this.callback.run();
            return;
        }
        Map.Entry<UHCPlayer, Location> entry = this.teleportations.next();
        this.teleportations.remove();
        UHCPlayer player = entry.getKey();
        Location location = entry.getValue();
        ++this.numberPlayers;
        TeleportationUtil.teleportPlayer(player, location, this.runnable);
    }
}

