/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.tasks.runnable;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.alert.CombatLog;
import eu.scorpionltd.uhc.events.custom.GameEpisodeEvent;
import eu.scorpionltd.uhc.events.custom.GameTimeEvent;
import eu.scorpionltd.uhc.events.custom.world.DayEvent;
import eu.scorpionltd.uhc.events.custom.world.DayTimeEvent;
import eu.scorpionltd.uhc.events.custom.world.NightEvent;
import eu.scorpionltd.uhc.events.custom.world.NightTimeEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.tasks.Timer;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.MethsUtil;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GameTimer
extends BukkitRunnable {
    private static int time = 0;
    private static int episode = 1;
    private boolean timeAnnonce = false;
    private List<UHCPlayer> checkGroup;

    public GameTimer() {
        this.runTaskTimer((Plugin)UHC.getInstance(), 0L, 20L);
        this.checkGroup = new ArrayList<UHCPlayer>();
    }

    public static int getEpisode() {
        return episode;
    }

    public static int getLastEpisode() {
        return episode - 1;
    }

    public static int getTime() {
        return time;
    }

    public static int getEpisodeTime() {
        return time - Values.TIMERS_EPISODE.getInteger() * GameTimer.getLastEpisode();
    }

    public void run() {
        int valueDirection;
        if (Status.getCurrentStatus().isFinish()) {
            this.cancel();
            return;
        }
        for (int i = 0; i < TimerManager.getTimers().size(); ++i) {
            Timer t = TimerManager.getTimers().get(i);
            if (!t.isActive()) continue;
            t.sec();
        }
        if (Values.CHAT_INDICATION_CENTER.getBoolean()) {
            List<Player> players = UHCPlayerManager.getOnlinePlayers();
            for (int i = 0; i < players.size(); ++i) {
                MethsUtil.senderCenterPosition(players.get(i));
            }
        }
        if ((valueDirection = Values.CHAT_DIRECTION_MATES.getInteger()) == 2 || valueDirection == 1 && TimerManager.hasTimerPVP()) {
            List<UHCPlayer> players = UHCPlayerManager.getOnlineUHCPlayers();
            for (int i = 0; i < players.size(); ++i) {
                UHCPlayer player = players.get(i);
                if (UHC.getTeam(player) == null) continue;
                PlayerUtil.sendDirectionalArrow(player, UHC.getTeam(player).getConnectedPlayers());
            }
        }
        if (WorldUtil.isDay()) {
            Bukkit.getPluginManager().callEvent((Event)new DayEvent());
            if (this.timeAnnonce) {
                this.timeAnnonce = false;
                if (Values.CHAT_TIME_ANNONCE.getBoolean()) {
                    MEnum.DAY_TIME.sendAll(episode);
                }
                Bukkit.getPluginManager().callEvent((Event)new DayTimeEvent());
            }
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NightEvent());
            if (!this.timeAnnonce) {
                this.timeAnnonce = true;
                if (Values.CHAT_TIME_ANNONCE.getBoolean()) {
                    MEnum.NIGHT_TIME.sendAll(episode);
                }
                Bukkit.getPluginManager().callEvent((Event)new NightTimeEvent());
            }
        }
        if (Values.TIMERS_EPISODE_ACTIVATION.getBoolean()) {
            int episodeSeconds = Values.TIMERS_EPISODE.getInteger();
            if (GameTimer.getTime() != 0 && GameTimer.getTime() % episodeSeconds == 0) {
                ++episode;
                if (Values.CHAT_EPISODE_ANNONCE.getBoolean()) {
                    MEnum.SEND_EPISODE.sendAll(episode);
                }
                Bukkit.getPluginManager().callEvent((Event)new GameEpisodeEvent(episode));
            }
        }
        Bukkit.getPluginManager().callEvent((Event)new GameTimeEvent(++time, episode));
        if (!TimerManager.hasTimerPVP() && ConfigFile.ALERTS_GROUP_NUMBER.getBoolean()) {
            int numberGroup = ChatUtil.getGroupes();
            for (UHCPlayer player : UHCPlayerManager.getOnlinePlayings()) {
                if (this.checkGroup.contains(player)) continue;
                List<UHCPlayer> proches = PlayerUtil.getNearUHCPlayers(20.0, player.getPlayer());
                boolean containsChecked = false;
                for (UHCPlayer checked : this.checkGroup) {
                    if (!proches.contains(checked)) continue;
                    containsChecked = true;
                }
                if (containsChecked) continue;
                proches.add(player);
                proches.removeIf(proche -> proche.getPlayer().hasPotionEffect(PotionEffectType.INVISIBILITY));
                int fight = (int)proches.stream().filter(proche -> CombatLog.isInCombat(proche)).count();
                if (fight > 2 * numberGroup) {
                    this.sendGroupAlert(player, fight, true);
                    continue;
                }
                int procheNumber = proches.size();
                if (procheNumber <= numberGroup) continue;
                this.sendGroupAlert(player, procheNumber, false);
            }
        }
    }

    private void sendGroupAlert(final UHCPlayer player, int numberPlayers, boolean inFight) {
        this.checkGroup.add(player);
        String fightName = inFight ? " (Combat)" : "";
        ChatUtil.sendAlert(ChatUtil.getAlert("Non-respect des groupes (" + numberPlayers + ")", player.getName() + fightName, player.getPlayer().getLocation()));
        new Cooldown(60){

            public void onFinish() {
                GameTimer.this.checkGroup.remove(player);
            }
        };
    }
}

