/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.tasks.runnable;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.GameManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.ui.player.infos.MenuGameRules;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.world.TeleportationUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CooldownTask
extends BukkitRunnable {
    private int time = ConfigFile.COOLDOWN_TIME.getInteger();
    private int locationsBySeconds;
    private List<World> worlds;
    private List<UHCPlayer> playersForLocations;
    private HashMap<UHCPlayer, Location> locations;

    public CooldownTask() {
        if (ConfigFile.COOLDOWN_RULES_MENU.getBoolean()) {
            Bukkit.getOnlinePlayers().forEach(player -> new MenuGameRules(ScorpionPlayer.getScorpionPlayer((Player)player)).openMenu());
        }
        this.worlds = new ArrayList<World>();
        for (GameWorld gameWorld : GameWorldManager.getTeleportationWorlds()) {
            this.worlds.add(gameWorld.getWorld());
        }
        this.locations = new HashMap();
        this.playersForLocations = UHCPlayerManager.getPlayings();
        this.locationsBySeconds = (int)Math.ceil((double)this.playersForLocations.size() / (double)(this.time - 1));
        System.out.println("CREATION OF TP POSITIONS: " + this.locationsBySeconds + "/s for " + this.playersForLocations.size() + " players");
        this.runTaskTimer((Plugin)UHC.getInstance(), 0L, 20L);
    }

    public void run() {
        if (this.time <= 0) {
            this.cancel();
            Bukkit.getOnlinePlayers().forEach(player -> {
                player.setLevel(0);
                player.setExp(0.0f);
            });
            GameManager.finishCooldown(this.locations);
            return;
        }
        if (this.time != 1) {
            TeleportationUtil.generateSpawnPoints(this.worlds, this.playersForLocations.iterator(), this.locations, this.locationsBySeconds);
            System.out.println(" + " + this.locationsBySeconds + " new positions");
        }
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (player2 == null || !player2.isOnline()) continue;
            if (this.time % 5 == 0 || this.time <= 4) {
                MEnum.COOLDOWN_TIME.sendTo(player2, ChatUtil.getTime(player2, (Integer)this.time));
            }
            if (ConfigFile.COOLDOWN_SOUND.getBoolean()) {
                player2.playSound(player2.getLocation(), Sound.ORB_PICKUP, 1.0f, 0.1f);
            }
            player2.setLevel(this.time);
        }
        --this.time;
    }

    public int getTime() {
        return this.time;
    }
}

