/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.tasks;

import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.tasks.Timer;
import eu.scorpionltd.uhc.tasks.runnable.game.ActionBarTask;
import eu.scorpionltd.uhc.tasks.runnable.game.CycleDayTask;
import eu.scorpionltd.uhc.tasks.timer.FinalHeal;
import eu.scorpionltd.uhc.tasks.timer.Invincibilite;
import eu.scorpionltd.uhc.tasks.timer.PvP;
import eu.scorpionltd.uhc.tasks.timer.TimeNether;
import eu.scorpionltd.uhc.tasks.timer.border.Meetup;
import eu.scorpionltd.uhc.util.server.enums.Gamerule;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class TimerManager {
    private static List<Timer> timers = new ArrayList<Timer>();
    private static CycleDayTask cycleDayTask = null;

    public static void registerTimers() {
        if (Values.TIMERS_DEGATS_ACTIVATION.getBoolean()) {
            new Invincibilite();
        }
        if (Values.TIMERS_FINAL_HEAL_ACTIVATION.getBoolean()) {
            new FinalHeal();
        }
        new PvP();
        if (Values.TIMERS_MEETUP_ACTIVATION.getBoolean()) {
            new Meetup();
        }
        if (Values.TIMERS_TIME_NETHER_ACTIVATION.getBoolean() && Values.NETHER_ACCESS.getBoolean()) {
            new TimeNether();
        }
    }

    public static void setupGame() {
        for (World w : Bukkit.getWorlds()) {
            Gamerule.DAY_CYCLE.set(w, false);
            w.setTime(22000L);
        }
        if (Values.OVERWORLD_DAY_CYCLE.getInteger() != 0) {
            cycleDayTask = new CycleDayTask();
        }
        if (ConfigFile.ACTIONBAR_ENABLE.getBoolean()) {
            new ActionBarTask();
        }
    }

    public static List<Timer> getTimers() {
        return timers;
    }

    public static List<Timer> getTimersActive() {
        return timers.stream().filter(timer -> timer.isActive()).collect(Collectors.toList());
    }

    public static Timer getTimerByKey(String key) {
        return timers.stream().filter(timer -> timer.getKey().equals(key)).findFirst().orElse(null);
    }

    public static Timer getTimerByKey(Values value) {
        return TimerManager.getTimerByKey(value.getVariable().getKey());
    }

    public static boolean hasTimerActive() {
        return timers.stream().anyMatch(timer -> timer.isActive());
    }

    public static boolean hasTimerFinalHeal() {
        return TimerManager.getTimerByKey(Values.TIMERS_FINAL_HEAL).isActive();
    }

    public static boolean hasTimerPVP() {
        return TimerManager.getTimerByKey(Values.TIMERS_PVP).isActive();
    }

    public static boolean hasTimerMeetup() {
        return TimerManager.getTimerByKey(Values.TIMERS_MEETUP).isActive();
    }

    public static void cancelCycleDayTask() {
        if (cycleDayTask == null) {
            return;
        }
        cycleDayTask.cancel();
        cycleDayTask = null;
    }
}

