/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.tasks;

import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.utils.objets.SymbolBank;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.ChatColor;

public abstract class Timer {
    private final Settings setting;
    protected int time;

    public Timer(Settings setting) {
        this.setting = setting;
        this.time = (Integer)setting.getValue();
        TimerManager.getTimers().add(this);
    }

    public Timer(Values value) {
        this(value.getSettings());
    }

    public void sec() {
        --this.time;
        this.onSec();
    }

    public abstract void onSec();

    public String getDisplayActive() {
        return ChatColor.GREEN + SymbolBank.OK;
    }

    public String getDisplayTime() {
        return ConfigFile.SB_TIMER_COLOR.getString() + String.format("%02d:%02d", this.time / 60, this.time % 60);
    }

    public boolean isActive() {
        return this.time > 0;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public Settings getSettings() {
        return this.setting;
    }

    public String getKey() {
        return this.setting.getVariable().getKey();
    }

    public String getPrefix(ScorpionPlayer sp) {
        return this.setting.getName(sp);
    }
}

