/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.scoreboard;

import eu.scorpionltd.scoreboard.SidebarManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.scenarios.Gamemode;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.tasks.runnable.GameTimer;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.task.Cooldown;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UHCScoreboard
extends SidebarManager {
    private int pve = 0;
    private boolean alternate = false;
    private UUID[] classement = new UUID[11];

    public void build(ScorpionPlayer p, SidebarManager.SidebarEditor e) {
        if (!Status.getCurrentStatus().isStart()) {
            this.sendLobbyTitle(e);
            this.sendLobbyScoreboard(p, e);
            return;
        }
        for (Gamemode gamemode : ScenarioManager.getActivatedGamemodes()) {
            if (!gamemode.haveScoreboard()) continue;
            gamemode.createScoreboard(p, e);
            return;
        }
        this.sendGameTitle(e);
        if (!Status.getCurrentStatus().isFinish()) {
            boolean showTopKill = !Values.CHAT_GAME.getBoolean() || this.alternate && (UHCPlayerManager.hasKill() || this.pve != 0);
            boolean bl = showTopKill;
            if (Values.CHAT_KILLS.getBoolean() && showTopKill) {
                this.sendTopKillScoreboard(p, e);
            } else if (Values.CHAT_GAME.getBoolean()) {
                this.sendGameScoreboard(p, e);
            }
            return;
        }
        this.sendTopKillScoreboard(p, e);
    }

    public void sendLobbyTitle(SidebarManager.SidebarEditor e) {
        String titleLobby = ChatUtil.convertText(ConfigFile.SB_LOBBY_TITLE.getString());
        e.setTitle(titleLobby);
    }

    public void sendGameTitle(SidebarManager.SidebarEditor e) {
        String titleGame = ChatUtil.convertText(ConfigFile.SB_GAME_TITLE.getString());
        e.setTitle(titleGame);
    }

    public void sendLobbyScoreboard(ScorpionPlayer p, SidebarManager.SidebarEditor e) {
        e.clear();
        for (String line : ConfigFile.SB_LOBBY_LINES.getListString()) {
            String final_line = ChatUtil.convertText(line);
            if (final_line.contains("<scenario_list>")) {
                for (Scenario sc : ScenarioManager.getActivatedScenarios()) {
                    e.add(final_line.replace("<scenario_list>", sc.getName()));
                }
                continue;
            }
            e.add(final_line);
        }
    }

    public void sendTopKillScoreboard(ScorpionPlayer p, SidebarManager.SidebarEditor e) {
        Integer i = 0;
        e.clear();
        while (i < 11 && this.classement[i] != null) {
            UUID uuid = this.classement[i];
            String name = "";
            UHCPlayer player = UHCPlayerManager.getPlayer(uuid);
            if (player.getInfos().getCurrentKills() > 0) {
                Player pt = player.getPlayer();
                String color = ConfigFile.SB_TK_DEATH.getString();
                if (player.isPlaying() && !player.isDeconnecting() && pt != null && pt.isOnline()) {
                    UHCTeam team = UHC.getTeam(player);
                    if (team != null && Values.TEAM_SHOW_PREFIX.getBoolean()) {
                        name = name + team.getPrefix().getPrefixName();
                    }
                    name = name + player.getName();
                    if (player.isPlaying()) {
                        color = ConfigFile.SB_TK_ALIVE.getString();
                    }
                } else {
                    name = player.getName();
                }
                e.setByScore(color + name, Integer.valueOf(player.getInfos().getCurrentKills()));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (this.pve != 0 && ConfigFile.SB_PVE.getBoolean()) {
            e.setByScore(ConfigFile.SB_PVE_TEXT.getString(), Integer.valueOf(this.pve));
        }
        if (!Status.getCurrentStatus().isFinish() && ConfigFile.SB_PLAYERS.getBoolean()) {
            e.setByScore(ConfigFile.SB_PLAYERS_TEXT.getString(), Integer.valueOf(UHCPlayerManager.getPlayersConnectedNumber()));
        }
    }

    public void sendGameScoreboard(ScorpionPlayer p, SidebarManager.SidebarEditor e) {
        UHCPlayer player = UHCPlayerManager.getPlayer(p);
        e.clear();
        for (String line : ConfigFile.SB_GAME_LINES.getListString()) {
            String final_line = ChatUtil.convertText(line);
            if (final_line.contains("<scenario_list>")) {
                for (Scenario sc : ScenarioManager.getActivatedScenarios()) {
                    e.add(final_line.replace("<scenario_list>", sc.getName()));
                }
                continue;
            }
            if (final_line.contains("<episode>")) {
                if (!Values.TIMERS_EPISODE_ACTIVATION.getBoolean()) continue;
                final_line = final_line.replace("<episode>", GameTimer.getEpisode() + "");
            }
            if (final_line.contains("<kills>")) {
                final_line = final_line.replace("<kills>", player.getInfos().getCurrentKills() + "");
            }
            if (final_line.contains("<team_kills>")) {
                if (!Values.CHAT_TEAM_KILLS.getBoolean() || Values.TEAM_FFA.getBoolean() || UHC.getTeam(p) == null) continue;
                final_line = final_line.replace("<team_kills>", UHC.getTeam(p).getTotalKills() + "");
            }
            if (player.getPlayer() != null && (final_line.contains("<distance_center>") || final_line.contains("<direction_center>"))) {
                Location location = player.getPlayer().getLocation();
                Location center = WorldUtil.getCenter(location);
                if (final_line.contains("<distance_center>")) {
                    final_line = final_line.replace("<distance_center>", PlayerUtil.getDistanceBlocks(location, center) + "");
                }
                if (final_line.contains("<direction_center>")) {
                    final_line = final_line.replace("<direction_center>", PlayerUtil.getDirectionalArrow(location, center));
                }
            }
            if (final_line.contains("<") && final_line.contains(">")) continue;
            e.add(final_line);
        }
    }

    public void uptadeAllTime() {
        Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)UHC.getInstance(), new Runnable(){

            @Override
            public void run() {
                UHC.getScoreboard().update();
            }
        }, 3L, 3L);
    }

    public void switchScoreboard() {
        new Cooldown(10){

            public void onFinish() {
                UHCScoreboard.this.alternate = !UHCScoreboard.this.alternate;
                UHCScoreboard.this.switchScoreboard();
            }
        };
    }

    public void generateScoreboardImage() {
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        for (int v = 0; v < 11 && this.classement[v] != null; ++v) {
            UUID uuid = this.classement[v];
            UHCPlayer player = UHCPlayerManager.getPlayer(uuid);
            if (player.getInfos().getCurrentKills() <= 0) continue;
            Player pt = player.getPlayer();
            String color = ConfigFile.SB_TK_ALIVE.getString();
            String name = "";
            if (pt != null) {
                UHCTeam team = UHC.getTeam(uuid);
                if (team != null) {
                    name = name + team.getPrefix().getPrefixName();
                }
                name = name + player.getName();
            } else {
                name = player.getName();
            }
            scores.put(color + name, player.getInfos().getCurrentKills());
        }
        if (this.pve != 0 && ConfigFile.SB_PVE.getBoolean()) {
            scores.put(ConfigFile.SB_PVE_TEXT.getString(), this.pve);
        }
        if (scores.isEmpty()) {
            if (this.pve == 0) {
                scores.put(ConfigFile.SB_PVE_TEXT.getString(), 8);
            }
            scores.put("TheMachuPichu", 6);
            scores.put("Sithey", 5);
            scores.put("Choukas", 3);
            scores.put("AquaEpee", 1);
        }
        LinkedHashMap collection = new LinkedHashMap();
        scores.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(e -> {
            Integer cfr_ignored_0 = (Integer)collection.put(e.getKey(), e.getValue());
        });
        int font_height = 10;
        int scaledHeight = 1080;
        int scaledWidth = 1920;
        int totalHeight = collection.size() * font_height;
        int centerY = scaledHeight / 2 + totalHeight / 3;
        int padding = 3;
        int titleWidth = ConfigFile.SB_GAME_TITLE.getString().length() * font_height;
        int alignX = scaledWidth - titleWidth - padding;
        int entryIndex = 0;
        BufferedImage image = new BufferedImage(scaledWidth, scaledHeight, 2);
        for (Map.Entry entry : collection.entrySet()) {
            String name = (String)entry.getKey();
            String val = ((Integer)entry.getValue()).toString();
            int y = centerY - ++entryIndex * font_height;
            int width = scaledWidth - padding + 2;
            Graphics2D gr = image.createGraphics();
            gr.setColor(new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 127));
            gr.fillRect(alignX - 2, y - font_height + 5, width, font_height);
            Graphics2D gName = image.createGraphics();
            gName.setColor(Color.WHITE);
            gName.drawString(name, alignX, y);
            Graphics2D gVal = image.createGraphics();
            gVal.setColor(Color.RED);
            gVal.drawString(val, width - val.length() * 8, y);
            if (entryIndex != collection.size()) continue;
            String title = ChatUtil.convertText(ConfigFile.SB_GAME_TITLE.getString());
            Graphics2D gTitle = image.createGraphics();
            gTitle.setColor(Color.WHITE);
            gTitle.drawString(title, alignX + titleWidth / 2 - title.length() / 2, y - font_height - 5);
        }
        try {
            File file = new File(UHC.getInstance().getDataFolder(), "scoreboard.png");
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setupClassement() {
        for (int i = 0; i <= 10; ++i) {
            UHC.getScoreboard().getClassement()[i] = null;
        }
    }

    public void fillClassement(Player player) {
        for (int i = 0; i <= 10; ++i) {
            if (UHC.getScoreboard().getClassement()[i] != null) continue;
            UHC.getScoreboard().getClassement()[i] = player.getUniqueId();
            break;
        }
    }

    public UUID[] getClassement() {
        return this.classement;
    }

    public void addPVE() {
        ++this.pve;
    }

    public int getPVE() {
        return this.pve;
    }
}

