/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.scoreboard;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TabManager {
    private static BukkitTask updateTask = null;

    public static void setupTab() {
        if (!ConfigFile.TAB_ENABLE.getBoolean()) {
            return;
        }
        TabManager.sendAll();
        TabManager.updateTab();
    }

    public static void updateTab() {
        if (updateTask != null) {
            updateTask.cancel();
        }
        updateTask = new BukkitRunnable(){

            public void run() {
                if (!ConfigFile.TAB_ENABLE.getBoolean() || !ConfigFile.TAB_UPDATE.getBoolean()) {
                    this.cancel();
                    return;
                }
                TabManager.sendAll();
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
    }

    public static void sendAll() {
        Bukkit.getOnlinePlayers().forEach(player -> TabManager.send(player));
    }

    public static void send(Player player) {
        String footer;
        if (!ConfigFile.TAB_ENABLE.getBoolean()) {
            return;
        }
        String header = ConfigFile.TAB_HEADER.getString();
        if (header == null) {
            header = "";
        }
        if ((header = ChatUtil.convertText(header)).contains("<ping>")) {
            header = header.replace("<ping>", PlayerUtil.getPing(player) + "");
        }
        if ((footer = ConfigFile.TAB_FOOTER.getString()) == null) {
            footer = "";
        }
        if ((footer = ChatUtil.convertText(footer)).contains("<ping>")) {
            footer = footer.replace("<ping>", PlayerUtil.getPing(player) + "");
        }
        ScorpionPlayer.getScorpionPlayer((Player)player).getPlayerPacket().setPlayerListHeaderAndFooter(header, footer);
    }
}

