/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.scoreboard;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.scoreboard.event.ArrowEvent;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardLife {
    private static Objective health = null;
    private static Objective healthBelow = null;

    public static void setup() {
        if (!Values.CHAT_LIFE.getBoolean()) {
            return;
        }
        ScoreboardLife.unregister();
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        if (ConfigFile.CHAT_LIFE_IN_TAB.getBoolean()) {
            health = scoreboard.registerNewObjective("health", "dummy");
            health.setDisplaySlot(DisplaySlot.PLAYER_LIST);
        }
        healthBelow = scoreboard.registerNewObjective("healthBelow", "dummy");
        healthBelow.setDisplayName("%");
        healthBelow.setDisplaySlot(DisplaySlot.BELOW_NAME);
        EventManager.registerEvent((Listener)new ArrowEvent(), (Plugin)UHC.getInstance());
    }

    public static void unregister() {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        if (scoreboard.getObjective("health") != null) {
            scoreboard.getObjective("health").unregister();
        }
        if (scoreboard.getObjective("healthBelow") != null) {
            scoreboard.getObjective("healthBelow").unregister();
        }
    }

    public static void setHealth(Player player) {
        if (!Values.CHAT_LIFE.getBoolean()) {
            return;
        }
        double absoHearths = 0.0;
        absoHearths = ScorpionPlayer.getScorpionPlayer((Player)player).getPlayerUtils().getAbsorptionHearths();
        int percent = (int)(player.getHealth() * 5.0 + absoHearths * 5.0);
        if (health != null) {
            health.getScore(player.getName()).setScore(percent);
        }
        healthBelow.getScore(player.getName()).setScore(percent);
    }

    public static void updateHealth(Player player) {
        if (!Values.CHAT_LIFE.getBoolean()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)UHC.getInstance(), () -> ScoreboardLife.setHealth(player), 2L);
    }
}

