/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.world;

import eu.scorpionltd.uhc.manager.world.GameEnvironment;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import eu.scorpionltd.uhc.util.world.monde.ArenaUtil;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.World;

public class GameWorldManager {
    private static List<GameWorld> gameWorlds;

    public static void initGameWorlds() {
        gameWorlds = new ArrayList<GameWorld>();
        LobbyUtil.initLobby();
        ArenaUtil.generateWorlds();
    }

    public static void resetGameWorlds() {
        gameWorlds.forEach(gameWorld -> {
            gameWorld.removePlayerData();
            gameWorld.resetNameFile();
        });
    }

    public static GameWorld createGameWorld(String name, String displayName, GameEnvironment environment) {
        if (GameWorldManager.existsGameWorld(name)) {
            return GameWorldManager.getGameWorld(name);
        }
        GameWorld gameWorld = new GameWorld(name, displayName, environment);
        return gameWorld;
    }

    public static GameWorld createCustomGameWorld(String name, String displayName, GameEnvironment environment) {
        GameWorld gameWorld = GameWorldManager.createGameWorld(name, displayName, environment);
        gameWorld.setCustomWorld(true);
        return gameWorld;
    }

    public static void changeTimerPvP(boolean value) {
        for (GameWorld gameWorld : GameWorldManager.getTimerPvPWorld()) {
            if (gameWorld.getWorld() == null) continue;
            WorldUtil.changePVP(gameWorld.getWorld(), value);
        }
    }

    public static List<GameWorld> getGameWorlds() {
        return gameWorlds;
    }

    public static List<GameWorld> getTeleportationWorlds() {
        return gameWorlds.stream().filter(gameWorld -> gameWorld.isGameWorld()).collect(Collectors.toList());
    }

    public static List<World> getTeleportationBukkitWorlds() {
        return gameWorlds.stream().filter(gameWorld -> gameWorld.isGameWorld() && gameWorld.getWorld() != null).map(gameWorld -> gameWorld.getWorld()).collect(Collectors.toList());
    }

    public static List<GameWorld> getTimerPvPWorld() {
        return gameWorlds.stream().filter(gameWorld -> gameWorld.isTimerPvP()).collect(Collectors.toList());
    }

    public static boolean existsGameWorld(String name) {
        return gameWorlds.stream().anyMatch(gameWorld -> gameWorld.getName() == name);
    }

    public static GameWorld getGameWorld(String name) {
        return gameWorlds.stream().filter(gameWorld -> gameWorld.getName() == name).findFirst().orElse(null);
    }

    public static GameWorld getGameWorld(World world) {
        return gameWorlds.stream().filter(gameWorld -> gameWorld.getWorld() != null && gameWorld.getWorld().getName().equals(world.getName())).findFirst().orElse(null);
    }

    public static GameWorld getLinkedWorld(GameWorld world) {
        return gameWorlds.stream().filter(gameWorld -> gameWorld.getNether() == world || gameWorld.getEnd() == world).findFirst().orElse(null);
    }
}

