/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.world;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.generation.LoadingChunk;
import eu.scorpionltd.uhc.generation.worldborder.WorldFillTask;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameEnvironment;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;

public class GameWorld {
    private String name;
    private String displayName;
    private World world;
    private GameEnvironment environment;
    private int worldNumber;
    private int customPregenSize;
    private boolean changeWorldNumber;
    private boolean isCustomWorld;
    private boolean isGameWorld;
    private boolean isTimerPvP;
    private boolean hasBorderGame;
    private boolean disablePregen;
    private String customGeneratorSettings;
    private List<BlockPopulator> populators;
    private GameWorld nether;
    private GameWorld end;

    public GameWorld(String name, String displayName, GameEnvironment environment, boolean changeWorldNumber, boolean isCustomWorld) {
        this.name = name;
        this.displayName = displayName;
        this.world = null;
        this.environment = environment;
        this.worldNumber = -1;
        this.customPregenSize = -1;
        this.changeWorldNumber = changeWorldNumber;
        this.isCustomWorld = isCustomWorld;
        this.isGameWorld = false;
        this.isTimerPvP = true;
        this.hasBorderGame = true;
        this.disablePregen = false;
        this.customGeneratorSettings = "";
        this.populators = new ArrayList<BlockPopulator>();
        this.nether = null;
        this.end = null;
        GameWorldManager.getGameWorlds().add(this);
    }

    public GameWorld(String name, String displayName, GameEnvironment environment) {
        this(name, displayName, environment, false, false);
    }

    public void removeGameWorld() {
        this.removeWorld();
        GameWorldManager.getGameWorlds().remove(this);
    }

    public GameWorld addNetherWorld() {
        this.nether = GameWorldManager.createGameWorld(this.name + "_nether", this.displayName + " Nether", GameEnvironment.NETHER);
        this.nether.setChangeWorldNumber(this.changeWorldNumber);
        this.nether.setCustomWorld(this.isCustomWorld);
        return this.nether;
    }

    public GameWorld addEndWorld() {
        this.end = GameWorldManager.createGameWorld(this.name + "_end", this.displayName + " End", GameEnvironment.END);
        this.end.setChangeWorldNumber(this.changeWorldNumber);
        this.end.setCustomWorld(this.isCustomWorld);
        return this.end;
    }

    public String getColorName() {
        return this.environment.getColor() + this.displayName;
    }

    public boolean existsWorldFile() {
        File file = new File(Bukkit.getServer().getWorldContainer(), this.getWorldName());
        return file.exists();
    }

    public boolean deteleWorldFile() {
        if (!this.existsWorldFile()) {
            return true;
        }
        File path = new File(Bukkit.getServer().getWorldContainer().getAbsolutePath() + "/" + this.getWorldName());
        if (this.world != null) {
            path = this.world.getWorldFolder();
        }
        WorldUtil.deleteFile(path);
        return true;
    }

    public boolean copyWorldFile() {
        if (!this.existsWorldFile()) {
            return true;
        }
        File path = new File(Bukkit.getServer().getWorldContainer().getAbsolutePath() + "/" + this.getWorldName());
        if (this.world != null) {
            path = this.world.getWorldFolder();
        }
        try {
            FileUtils.copyDirectory((File)path, (File)new File(Bukkit.getServer().getWorldContainer().getAbsolutePath() + "/" + this.getName()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void removeWorld() {
        if (this.world != null) {
            Bukkit.getServer().unloadWorld(this.world, false);
            this.deteleWorldFile();
        }
        System.out.println("GAME GENERATION: REMOVE WORLD " + this.name);
    }

    public void loadOrGenerateWorld() {
        if (this.existsWorldFile()) {
            this.loadWorld();
        } else {
            this.generateWorld();
        }
    }

    public World loadWorld() {
        String worldName = this.updateWorldName();
        WorldCreator wc = new WorldCreator(worldName);
        wc.environment(this.environment.getEnvironment());
        this.world = wc.createWorld();
        this.world.setAutoSave(false);
        this.world.setSpawnLocation(0, 150, 0);
        System.out.println("GAME GENERATION: LOAD WORLD " + this.name);
        return this.world;
    }

    public boolean canBeGenerate() {
        if (this.isCustomWorld) {
            return false;
        }
        return this.environment == GameEnvironment.OVERWORLD || this.environment == GameEnvironment.NETHER && Values.NETHER_ACCESS.getBoolean() || this.environment == GameEnvironment.END && Values.END_ACCESS.getBoolean();
    }

    public World generateWorld(WorldType worldType, String generatorSettings) {
        String worldName = this.updateWorldName();
        WorldCreator wc = new WorldCreator(worldName);
        wc.environment(this.environment.getEnvironment());
        wc.type(worldType);
        if (generatorSettings != null && generatorSettings != "") {
            wc.generatorSettings(generatorSettings);
        }
        this.world = wc.createWorld();
        this.world.setAutoSave(false);
        this.world.setSpawnLocation(0, 150, 0);
        System.out.println("GAME GENERATION: GENERATE WORLD " + this.name);
        return this.world;
    }

    public World generateWorld() {
        return this.generateWorld(WorldType.NORMAL, "");
    }

    public boolean isDisabledPregen() {
        return this.disablePregen;
    }

    public void setDisablePregen(boolean value) {
        this.disablePregen = value;
    }

    public boolean canBePregenerate() {
        if (this.disablePregen) {
            return false;
        }
        return this.isCustomWorld || this.environment == GameEnvironment.OVERWORLD || this.environment == GameEnvironment.NETHER && Values.NETHER_ACCESS.getBoolean() || this.environment == GameEnvironment.END && Values.END_ACCESS.getBoolean();
    }

    public void pregenerateWorld() {
        int chunksPerRun = 20;
        if (!Values.POPULATOR_NEW_PREGEN_SYSTEM.getBoolean()) {
            new LoadingChunk(this, this.environment.getValueCategorie()).load();
        } else {
            int size = this.haveCustomPregenSize() ? this.getCustomPregenSize() : Values.BORDER_SIZE_INIT.getInteger() + 100;
            WorldFillTask wft = new WorldFillTask(this, chunksPerRun, size);
            wft.setTaskID(Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)UHC.getInstance(), (Runnable)wft, 1L, 1L));
        }
    }

    public void removePlayerData() {
        if (this.world == null) {
            return;
        }
        File playerData = new File(this.world.getWorldFolder(), "playerdata");
        WorldUtil.deleteFile(playerData);
        playerData.mkdir();
        playerData.setExecutable(true, true);
        playerData.setWritable(true, true);
        playerData.setReadable(true, true);
        if (this.world.getWorldBorder() != null) {
            this.world.getWorldBorder().reset();
        }
    }

    public void resetNameFile() {
        if (!this.changeWorldNumber || this.isSameName()) {
            return;
        }
        this.copyWorldFile();
        this.removeWorld();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isSameName() {
        if (!this.changeWorldNumber) {
            return true;
        }
        return this.worldNumber <= 0;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public String getWorldName() {
        String worldName = this.name;
        if (this.changeWorldNumber && this.worldNumber > 0) {
            worldName = worldName + this.worldNumber;
        }
        return worldName;
    }

    public String updateWorldName() {
        if (this.changeWorldNumber) {
            ++this.worldNumber;
        }
        return this.getWorldName();
    }

    public GameEnvironment getGameEnvironment() {
        return this.environment;
    }

    public boolean haveCustomPregenSize() {
        return this.customPregenSize != -1;
    }

    public int getCustomPregenSize() {
        return this.customPregenSize;
    }

    public void setCustomPregenSize(int customPregenSize) {
        this.customPregenSize = customPregenSize;
    }

    public boolean isChangeWorldNumber() {
        return this.changeWorldNumber;
    }

    public void setChangeWorldNumber(boolean changeWorldNumber) {
        this.changeWorldNumber = changeWorldNumber;
    }

    public boolean isCustomWorld() {
        return this.isCustomWorld;
    }

    public void setCustomWorld(boolean isCustomWorld) {
        this.isCustomWorld = isCustomWorld;
    }

    public boolean isGameWorld() {
        return this.isGameWorld;
    }

    public void setGameWorld(boolean isGameWorld) {
        this.isGameWorld = isGameWorld;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    public boolean isTimerPvP() {
        return this.isTimerPvP;
    }

    public void setTimerPvP(boolean isTimerPvP) {
        this.isTimerPvP = isTimerPvP;
    }

    public boolean hasBorderGame() {
        return this.hasBorderGame;
    }

    public void setBorderGame(boolean hasBorderGame) {
        this.hasBorderGame = hasBorderGame;
    }

    public String getCustomGeneratorSettings() {
        return this.customGeneratorSettings;
    }

    public boolean haveCustomGeneratorSettings() {
        return this.customGeneratorSettings != "";
    }

    public void setCustomGeneratorSettings(String customGeneratorSettings) {
        this.customGeneratorSettings = customGeneratorSettings;
    }

    public void resetCustomGeneratorSettings() {
        this.customGeneratorSettings = "";
    }

    public GameWorld getNether() {
        return this.nether;
    }

    public void setNether(GameWorld nether) {
        this.nether = nether;
    }

    public GameWorld getEnd() {
        return this.end;
    }

    public void setEnd(GameWorld end) {
        this.end = end;
    }
}

