/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.teams;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.util.chat.color.Colors;
import eu.scorpionltd.uhc.util.chat.color.Prefix;
import eu.scorpionltd.uhc.util.chat.color.Symbols;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Scoreboard;

public class UHCTeamManager {
    private static UHCTeamManager instance;
    private Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
    private List<UHCTeam> teams = new ArrayList<UHCTeam>();
    private int id = 0;

    public NameTagVisibility getNameTagVisiblity() {
        int value = Values.TEAM_NAME_TAG_VISIBILITY.getInteger();
        if (value == 0) {
            return NameTagVisibility.ALWAYS;
        }
        if (value == 1) {
            return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
        }
        if (value == 2) {
            return NameTagVisibility.HIDE_FOR_OWN_TEAM;
        }
        return NameTagVisibility.NEVER;
    }

    public int getPageTeams() {
        return (int)Math.ceil(this.id / 35) + 1;
    }

    public int getTeamSlots() {
        return Values.TEAM_NUMBER.getInteger();
    }

    public boolean isChoosedTeam() {
        return Values.TEAM_CHOOSEN_TEAM.getBoolean();
    }

    public boolean isTeleportableTeam() {
        return Values.TEAM_TELEPORTATION_TOGETHER.getBoolean();
    }

    public Settings getTeamType() {
        return SettingsManager.getSettings(ValueCategorie.TEAM_SELECTION).stream().filter(value -> (Boolean)value.getValue()).findFirst().orElse(SettingsManager.getSettings("team.ffa"));
    }

    public String getTeamName() {
        String players = "";
        if (!Values.TEAM_FFA.getBoolean() && !Values.TEAM_RED_VS_BLUE.getBoolean()) {
            players = players + this.getTeamSlots();
        }
        return this.getTeamType().getName(LangueManager.getDefaultLangue()) + players;
    }

    public int getTeamNumber() {
        return new BigDecimal(Values.SERVER_SLOTS.getInteger()).divide(new BigDecimal(this.getTeamSlots()), 0, RoundingMode.CEILING).intValue();
    }

    public boolean canTeamSelection() {
        return Values.TEAM_MODE.getInteger() == 0 && this.isChoosedTeam();
    }

    public void setupTeams() {
        this.scoreboard.getTeams().forEach(team -> team.unregister());
        if (this.canTeamSelection()) {
            int teamNumber = this.getTeamNumber();
            for (Prefix prefix : Prefix.getAllPrefix()) {
                if (this.id >= teamNumber) {
                    return;
                }
                new UHCTeam(prefix);
            }
        }
    }

    public UHCTeam getTeam(UHCPlayer up) {
        return this.teams.stream().filter(team -> team.getPlayers().contains(up)).findFirst().orElse(null);
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public List<UHCTeam> getTeams() {
        return this.teams;
    }

    public int getID() {
        return this.id;
    }

    public void addID() {
        ++this.id;
    }

    public List<UHCTeam> getAliveTeams() {
        return this.teams.stream().filter(team -> !team.getAlivePlayers().isEmpty()).collect(Collectors.toList());
    }

    public List<UHCTeam> getConnectedTeams() {
        return this.teams.stream().filter(team -> !team.getConnectedPlayers().isEmpty()).collect(Collectors.toList());
    }

    public void joinRandomTeam(UHCPlayer up) {
        if (Values.TEAM_MODE.getInteger() == 1) {
            new UHCTeam(up);
            return;
        }
        List availableTeams = this.teams.stream().filter(t -> !t.isFullTeam()).collect(Collectors.toList());
        if (availableTeams.isEmpty()) {
            new UHCTeam(up);
            return;
        }
        Collections.shuffle(availableTeams);
        ((UHCTeam)availableTeams.get(0)).add(up);
    }

    public void randomTeams() {
        ArrayList<UHCPlayer> players = new ArrayList<UHCPlayer>(UHCPlayerManager.getPlayings());
        Collections.shuffle(players);
        int maxSize = this.getTeamSlots();
        int index = 0;
        while (index <= players.size()) {
            int nextIndex = index + maxSize;
            this.attributeToTeam(players.subList(index, nextIndex > players.size() ? players.size() : nextIndex));
            index = nextIndex;
        }
    }

    public void randomTeamsRedVSBlue() {
        ArrayList<UHCPlayer> players = new ArrayList<UHCPlayer>(UHCPlayerManager.getPlayings());
        Collections.shuffle(players);
        int split = players.size() / 2 + (players.size() % 2 != 0 ? 1 : 0);
        List<UHCPlayer> blueTeam = players.subList(0, split);
        List<UHCPlayer> redTeam = players.subList(split, players.size());
        this.attributeToTeamRedVSBlue(blueTeam, false);
        this.attributeToTeamRedVSBlue(redTeam, true);
    }

    private void attributeToTeam(List<UHCPlayer> ups) {
        UHCTeam team = new UHCTeam();
        ups.forEach(up -> team.add((UHCPlayer)up));
    }

    private void attributeToTeamRedVSBlue(List<UHCPlayer> ups, boolean isRedTeam) {
        Prefix prefix = isRedTeam ? new Prefix(Colors.RED, Symbols.NONE) : new Prefix(Colors.BLUE, Symbols.NONE);
        UHCTeam team = new UHCTeam(null, prefix);
        ups.forEach(up -> team.add((UHCPlayer)up));
    }

    public void generateTeams() {
        if (Values.TEAM_FFA.getBoolean() || Values.TEAM_TIMED_TEAM.getBoolean()) {
            return;
        }
        if (Values.TEAM_RED_VS_BLUE.getBoolean()) {
            this.randomTeamsRedVSBlue();
            return;
        }
        if (Values.TEAM_RANDOM_TEAM.getBoolean() || Values.TEAM_MYSTERY_TEAM.getBoolean()) {
            this.randomTeams();
            return;
        }
        for (UHCPlayer player : UHCPlayerManager.getPlayings()) {
            UHCTeam team = this.getTeam(player);
            if (team != null) continue;
            this.joinRandomTeam(player);
        }
    }

    public static UHCTeamManager getInstance() {
        if (instance == null) {
            instance = new UHCTeamManager();
            instance.setupTeams();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = new UHCTeamManager();
        instance.setupTeams();
    }

    public static void resetTeamSystem() {
        for (UHCPlayer player : UHCPlayerManager.getPlayings()) {
            UHCTeam team = UHC.getTeam(player);
            if (team == null) continue;
            team.resetDisplay(player);
        }
        UHCTeamManager.resetInstance();
        MEnum.RESET_TEAMS.sendAll(new Object[0]);
        InventoryUtil.giveAllJoinItems();
    }
}

