/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.teams;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeamManager;
import eu.scorpionltd.uhc.util.chat.color.Prefix;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class UHCTeam {
    private int id;
    private Team team;
    private UHCPlayer owner;
    private String teamName;
    private Prefix prefix;
    private Set<UHCPlayer> players;
    private Set<UHCPlayer> pendingInvitations;

    public UHCTeam(UHCPlayer owner, Prefix prefix) {
        UHCTeamManager manager = UHC.getTeamManager();
        this.id = manager.getID();
        this.owner = owner;
        this.prefix = prefix == null ? (Values.TEAM_MODE.getInteger() == 0 ? Prefix.getNextPrefix() : Prefix.getRandom()) : prefix;
        this.players = new HashSet<UHCPlayer>();
        this.pendingInvitations = new HashSet<UHCPlayer>();
        this.setupTeam();
        manager.addID();
        manager.getTeams().add(this);
    }

    public UHCTeam(Prefix prefix) {
        this(null, prefix);
    }

    public UHCTeam(UHCPlayer owner) {
        this(owner, null);
    }

    public UHCTeam() {
        this(null, null);
    }

    private void setupTeam() {
        Scoreboard scoreboard = UHCTeamManager.getInstance().getScoreboard();
        if (this.owner != null) {
            this.teamName = this.owner.getName();
            if (scoreboard.getTeam(this.teamName) != null) {
                scoreboard.getTeam(this.teamName).unregister();
            }
            this.team = scoreboard.registerNewTeam(this.teamName);
            this.add(this.owner);
        } else {
            this.teamName = this.prefix.getPrefixName();
            if (scoreboard.getTeam(this.teamName) != null) {
                scoreboard.getTeam(this.teamName).unregister();
            }
            this.team = scoreboard.registerNewTeam(this.teamName);
        }
        this.team.setPrefix(this.prefix.getPrefixName());
        this.team.setSuffix("\u00a7r");
        this.team.setAllowFriendlyFire(Values.TEAM_FRIENDLYFIRE.getInteger() == 1);
        this.team.setCanSeeFriendlyInvisibles(Values.TEAM_SEE_INVISIBLE_PLAYER.getInteger() == 1);
        this.team.setNameTagVisibility(UHCTeamManager.getInstance().getNameTagVisiblity());
    }

    public boolean isOwner(UHCPlayer uuid) {
        return this.owner != null && this.owner.equals(uuid);
    }

    public void add(UHCPlayer up) {
        UHCTeamManager manager = UHC.getTeamManager();
        if (this.pendingInvitations.contains(up)) {
            this.pendingInvitations.remove(up);
        }
        if (manager.isChoosedTeam() && this.isFullTeam()) {
            MEnum.FULL_TEAM.send(up, new Object[0]);
            return;
        }
        if (UHC.getTeam(up) != null) {
            UHC.getTeam(up).leave(up);
        }
        if (!Values.TEAM_MYSTERY_TEAM.getBoolean()) {
            MEnum.JOIN_NEW_TEAM.send(up, this.owner != null ? this.owner.getName() : this.prefix.getTextName());
        }
        if (Values.TEAM_SHOW_PREFIX.getBoolean()) {
            this.team.addEntry(up.getName());
        }
        this.players.add(up);
        if (manager.isChoosedTeam() && this.players.size() > 1) {
            MEnum.JOIN_TEAM.sendTeam(this, up.getName());
        }
        this.sendDisplay(up);
    }

    public void addGame(UHCPlayer up) {
        if (Values.TEAM_SHOW_PREFIX.getBoolean()) {
            this.team.addEntry(up.getName());
        }
        this.players.add(up);
        this.sendDisplay(up);
    }

    public void leave(UHCPlayer up) {
        String playerName;
        UHCTeamManager manager = UHC.getTeamManager();
        if (Values.TEAM_MODE.getInteger() == 1 && this.players.size() == 1 && manager.isChoosedTeam()) {
            MEnum.DELETE_TEAM.send(up, new Object[0]);
            this.removeTeam();
            return;
        }
        if (manager.isChoosedTeam()) {
            MEnum.LEAVE_TEAM.sendTeam(this, up.getName());
            this.resetDisplay(up);
        }
        if (this.team.hasEntry(playerName = up.getName())) {
            this.team.removeEntry(playerName);
        }
        this.players.remove(up);
    }

    public void leaveGame(UHCPlayer up) {
        String playerName = up.getName();
        if (this.team.hasEntry(playerName)) {
            this.team.removeEntry(playerName);
        }
        this.players.remove(up);
        this.resetDisplay(up);
    }

    public boolean hasPlayer(UHCPlayer up) {
        return this.players.contains(up);
    }

    public void updatePrefix(String prefix) {
        this.team.setPrefix(prefix);
        for (UHCPlayer player : this.getConnectedPlayers()) {
            String playerName = player.getName();
            if (!this.team.hasEntry(playerName) && prefix != "\u00a7r") {
                this.team.addEntry(playerName);
            }
            this.sendDisplay(player);
        }
    }

    public void updatePlayerPrefix(UHCPlayer player, String prefix) {
        Player p;
        this.team.setPrefix(prefix);
        String playerName = player.getName();
        if (!this.team.hasEntry(playerName) && prefix != "\u00a7r") {
            this.team.addEntry(playerName);
        }
        if ((p = player.getPlayer()).isOnline()) {
            p.setDisplayName(this.team.getPrefix() + playerName);
            p.setPlayerListName(p.getDisplayName());
        }
    }

    public void sendDisplay(UHCPlayer up) {
        Player player = up.getPlayer();
        if (player.isOnline()) {
            if (Values.TEAM_SHOW_PREFIX.getBoolean()) {
                player.setDisplayName(this.team.getPrefix() + player.getName());
                player.setPlayerListName(player.getDisplayName());
                this.team.addEntry(up.getName());
            } else {
                this.resetDisplay(up);
            }
        }
    }

    public void resetDisplay(UHCPlayer up) {
        Player player = up.getPlayer();
        if (player.isOnline()) {
            player.setDisplayName(player.getName());
            player.setPlayerListName(player.getDisplayName());
        }
    }

    public void sendInvitation(final UHCPlayer up) {
        if (this.owner == null || this.players.contains(up)) {
            return;
        }
        UHCPlayer owner = this.owner;
        MEnum.SEND_INVIT_TEAM.send(owner, new Object[0]);
        MEnum.RECEIVE_INVIT_TEAM.send(up, owner.getName());
        Player player = up.getPlayer();
        player.spigot().sendMessage(new ComponentBuilder(ChatColor.LIGHT_PURPLE + "/team accept " + owner.getName()).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team accept " + owner.getName())).create());
        this.pendingInvitations.add(up);
        new Cooldown(40){

            public void onFinish() {
                if (UHCTeam.this.pendingInvitations.contains(up)) {
                    UHCTeam.this.pendingInvitations.remove(up);
                }
            }
        };
    }

    public void removeTeam() {
        for (UHCPlayer up : this.getPlayers()) {
            Player player = up.getPlayer();
            if (player == null) continue;
            player.setDisplayName(player.getName());
        }
        if (this.team != null) {
            this.team.unregister();
        }
        UHCTeamManager.getInstance().getTeams().remove(this);
    }

    public void giveTeamItem(Player player) {
        int bannerType = Values.TEAM_BANNER_TYPE.getInteger();
        if (bannerType == 0) {
            return;
        }
        if (bannerType == 1) {
            InventoryUtil.addItem(player, this.prefix.getBanner());
        } else {
            InventoryUtil.addItem(player, this.prefix.getFirework());
        }
    }

    public int getID() {
        return this.id;
    }

    public Team getTeam() {
        return this.team;
    }

    public int getTotalKills() {
        return this.getPlayers().stream().mapToInt(player -> player.getInfos().getCurrentKills()).sum();
    }

    public int getAliveKills() {
        return this.getAlivePlayers().stream().mapToInt(player -> player.getInfos().getCurrentKills()).sum();
    }

    public UHCPlayer getOwner() {
        return this.owner;
    }

    public Prefix getPrefix() {
        return this.prefix;
    }

    public Set<UHCPlayer> getPlayers() {
        return this.players;
    }

    public Set<UHCPlayer> getConnectedPlayers() {
        return this.getPlayers().stream().filter(player -> player.isPlaying() && player.getPlayer() != null && player.getPlayer().isOnline()).collect(Collectors.toSet());
    }

    public Set<UHCPlayer> getAlivePlayers() {
        return this.getPlayers().stream().filter(player -> player.isPlaying()).collect(Collectors.toSet());
    }

    public UHCPlayer getRandomPlayer() {
        List alivePlayers = this.getAlivePlayers().stream().collect(Collectors.toList());
        return (UHCPlayer)alivePlayers.get(new Random().nextInt(alivePlayers.size()));
    }

    public Set<UHCPlayer> getDeathPlayers() {
        return this.getPlayers().stream().filter(player -> player.isDead()).collect(Collectors.toSet());
    }

    public Set<UHCPlayer> getPendingInvitations() {
        return this.pendingInvitations;
    }

    public boolean isFullTeam() {
        return this.players.size() >= UHC.getTeamManager().getTeamSlots();
    }
}

