/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.values;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public enum ValueCategorie {
    SCENARIO(1, "Scenarios", 4, Material.BEACON, ChatColor.GREEN),
    OVERWORLD(1, "OverWorld", 2, Material.GRASS, ChatColor.GREEN),
    NETHER(2, "Nether", 3, Material.NETHERRACK, ChatColor.RED),
    END(3, "End", 4, Material.ENDER_STONE, ChatColor.DARK_PURPLE),
    LOBBY(4, "Lobby", 6, Material.STAINED_GLASS, ChatColor.GRAY),
    CRAFT(1, "Crafts", 2, Material.WORKBENCH, ChatColor.GOLD),
    ENCHANTMENT(2, "Enchantments", 3, Material.ENCHANTMENT_TABLE, ChatColor.AQUA),
    POTION(3, "Potions", 4, Material.BREWING_STAND_ITEM, ChatColor.LIGHT_PURPLE),
    CUSTOM_CRAFT(4, "CustomCrafts", 6, Material.PISTON_STICKY_BASE, ChatColor.DARK_GREEN),
    ITEM(1, "Items", 2, Material.STICK, ChatColor.GOLD),
    EFFECT(3, "Effects", 4, Material.POTION, ChatColor.LIGHT_PURPLE),
    DIAMOND_ENCHANT(5, "Diamond Equipment", 48, Material.DIAMOND_CHESTPLATE, ChatColor.YELLOW),
    GLOBAL_ENCHANT(2, "Global", 49, Material.BOOK, ChatColor.YELLOW),
    IRON_ENCHANT(6, "Iron Equipment", 50, Material.IRON_CHESTPLATE, ChatColor.YELLOW),
    RULES_MINING(1, "Minage", 2, Material.GOLD_PICKAXE, ChatColor.GOLD),
    RULES_PLAYER(2, "Player", 3, Material.WORKBENCH, ChatColor.AQUA),
    RULES_DEATH(3, "Death", 4, Material.MOSSY_COBBLESTONE, ChatColor.RED),
    CHAT_MESSAGE(1, "Messages", 2, Material.BOOK, ChatColor.GOLD),
    CHAT_SCOREBOARD(2, "Scoreboard", 3, Material.IRON_DOOR, ChatColor.GREEN),
    CHAT_COMMAND(3, "Commandes", 4, Material.SIGN, ChatColor.RED),
    ENTITY_DROP(2, "Drops", 3, Material.SULPHUR, ChatColor.AQUA),
    ENTITY_SPAWN(1, "Spawns", 4, Material.MONSTER_EGG, ChatColor.GOLD),
    ENTITY_SPECS(3, "Specificity", 5, Material.BLAZE_ROD, ChatColor.AQUA),
    BLOCKS(0, "Blocks", 3, Material.GOLD_ORE, ChatColor.GOLD),
    TEAM(0, "Teams", 0, Material.BANNER, ChatColor.GRAY),
    TEAM_SELECTION(0, "Team Selection", 0, Material.BANNER, ChatColor.DARK_GRAY),
    BORDER(0, "Border", 0, Material.BEDROCK, ChatColor.BLUE),
    TIMERS(0, "Timers", 0, Material.WATCH, ChatColor.GOLD),
    SERVER(0, "Server", 0, Material.COMMAND, ChatColor.RED),
    INVENTORY(0, "Inventory", 0, Material.CHEST, ChatColor.GREEN),
    GENERATION_BIOMES_ENABLE(1, "Activated Biomes", 3, Material.WOOD, ChatColor.GREEN),
    GENERATION_BIOMES_CENTER(2, "Center Biome", 4, Material.GLASS, ChatColor.YELLOW),
    GENERATION_BLOCKS(3, "Block Generation", 5, Material.DIAMOND_ORE, ChatColor.AQUA);

    private String name;
    private Material mat;
    private ChatColor color;
    private int categorie;
    private int slot;

    private ValueCategorie(int categorie, String name, int slot, Material mat, ChatColor color) {
        this.mat = mat;
        this.color = color;
        this.name = name;
        this.categorie = categorie;
        this.slot = slot;
    }

    public int getCategorie() {
        return this.categorie;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public Material getMaterial() {
        return this.mat;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String getColorName() {
        return this.color + this.name;
    }

    public String getCategorieName() {
        return ChatColor.GRAY + "(" + this.color + this.name + ChatColor.GRAY + ")";
    }

    public Item getItem() {
        return new Item(this.mat, this.color + this.name);
    }

    public void addCategorieItem(CustomInventory inv) {
        inv.addCategorieItem(this.categorie, this.slot, this.getItem(), MEnum.SELECTED_MENU.getText(inv.getScorpionPlayer(), new Object[0]), MEnum.SELECTION_MENU.getText(inv.getScorpionPlayer(), new Object[0]));
    }

    public void addSpecialCategorieItem(CustomInventory inv, int main_categorie) {
        inv.addSpecialCategorieItem(this.categorie, this.slot, main_categorie, this.getItem(), MEnum.SELECTED_MENU.getText(inv.getScorpionPlayer(), new Object[0]), MEnum.SELECTION_MENU.getText(inv.getScorpionPlayer(), new Object[0]));
    }

    public static List<ValueCategorie> getMondesType() {
        return Arrays.asList(OVERWORLD, NETHER, END, LOBBY);
    }

    public static List<ValueCategorie> getObjetsType() {
        return Arrays.asList(CRAFT, ENCHANTMENT, POTION, CUSTOM_CRAFT);
    }

    public static List<ValueCategorie> getEnchantmentsType() {
        return Arrays.asList(GLOBAL_ENCHANT, DIAMOND_ENCHANT, IRON_ENCHANT);
    }

    public static List<ValueCategorie> getRulesType() {
        return Arrays.asList(RULES_MINING, RULES_PLAYER, RULES_DEATH);
    }

    public static List<ValueCategorie> getChatType() {
        return Arrays.asList(CHAT_MESSAGE, CHAT_SCOREBOARD, CHAT_COMMAND);
    }

    public static List<ValueCategorie> getEntityType() {
        return Arrays.asList(ENTITY_DROP, ENTITY_SPAWN, ENTITY_SPECS);
    }

    public static List<ValueCategorie> getGenerationType() {
        return Arrays.asList(GENERATION_BIOMES_ENABLE, GENERATION_BIOMES_CENTER, GENERATION_BLOCKS);
    }
}

