/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.templates;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.templates.Template;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TemplateManager {
    private static List<Template> templates;

    public static void loadTemplates() {
        List<File> files = TemplateManager.getTemplatesFile();
        templates = new ArrayList<Template>();
        if (files.isEmpty()) {
            Template original = new Template("Original");
            original.inverseDefault();
        } else {
            files.forEach(f -> new Template((File)f));
        }
        SettingsManager.loadSettings();
    }

    public static void saveTemplates() {
        templates.forEach(template -> template.saveFile());
    }

    public static List<File> getTemplatesFile() {
        List<Object> filesName = new ArrayList();
        if (Files.notExists(Paths.get(UHC.getInstance().getDataFolder() + "/templates", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(Paths.get(UHC.getInstance().getDataFolder() + "/templates", new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (Stream<Path> walk = Files.walk(Paths.get(UHC.getInstance().getDataFolder() + "/templates", new String[0]), new FileVisitOption[0]);){
            filesName = walk.map(x -> x.toString()).filter(f -> f.endsWith(".yml")).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<File>();
        }
        ArrayList<File> files = new ArrayList<File>();
        filesName.forEach(name -> files.add(new File((String)name)));
        return files;
    }

    public static List<Template> getTemplates() {
        return templates;
    }

    public static Template getDefaultTemplate() {
        return templates.stream().filter(template -> template.isDefault()).findFirst().orElse(null);
    }
}

