/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.templates;

import eu.scorpionltd.uhc.UHC;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TemplateFile {
    private File file;
    private FileConfiguration configFile;

    public TemplateFile(String name) {
        this.file = new File(UHC.getInstance().getDataFolder() + "/templates/" + name + ".yml");
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
                this.configFile.set("options.isDefault", (Object)false);
                this.saveFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create " + name + ".yml!");
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public void setValue(String path, Object object) {
        this.configFile.set(path, object);
    }

    public boolean getBoolean(String path) {
        return this.configFile.getBoolean(path);
    }

    public Object getObject(String path) {
        return this.configFile.get(path);
    }

    public boolean contains(String path) {
        return this.configFile.contains(path);
    }

    public void saveFile() {
        try {
            this.configFile.save(this.file);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not save " + this.file.getName() + " !");
        }
    }

    public void reloadFile() {
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.saveFile();
    }
}

